% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.R
\name{funnel.meta}
\alias{funnel.meta}
\alias{funnel}
\title{Funnel plot}
\usage{
\method{funnel}{meta}(
  x,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  common = x$common,
  random = x$random,
  axes = TRUE,
  pch = if (!inherits(x, "trimfill")) 21 else ifelse(x$trimfill, 1, 21),
  text = NULL,
  cex = 1,
  lty.common = 2,
  lty.random = 9,
  lwd = 1,
  lwd.common = lwd,
  lwd.random = lwd,
  col = "black",
  bg = "darkgray",
  col.common = "black",
  col.random = "black",
  log,
  yaxis,
  contour.levels = NULL,
  col.contour,
  ref = ifelse(is_relative_effect(x$sm), 1, 0),
  level = if (common | random) x$level else NULL,
  studlab = FALSE,
  cex.studlab = 0.8,
  pos.studlab = 2,
  ref.triangle = FALSE,
  lty.ref = 1,
  lwd.ref = lwd,
  col.ref = "black",
  lty.ref.triangle = 5,
  backtransf = x$backtransf,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{xlim}{The x limits (min,max) of the plot.}

\item{ylim}{The y limits (min,max) of the plot.}

\item{xlab}{A label for the x-axis.}

\item{ylab}{A label for the y-axis.}

\item{common}{A logical indicating whether the common effect
estimate should be plotted.}

\item{random}{A logical indicating whether the random effects
estimate should be plotted.}

\item{axes}{A logical indicating whether axes should be drawn on
the plot.}

\item{pch}{The plotting symbol used for individual studies.}

\item{text}{A character vector specifying the text to be used
instead of plotting symbol.}

\item{cex}{The magnification to be used for plotting symbol.}

\item{lty.common}{Line type (common effect estimate).}

\item{lty.random}{Line type (random effects estimate).}

\item{lwd}{The line width for confidence intervals (if \code{level}
is not \code{NULL}).}

\item{lwd.common}{The line width for common effect estimate (if
\code{common} is not \code{NULL}).}

\item{lwd.random}{The line width for random effects estimate (if
\code{random} is not \code{NULL}).}

\item{col}{A vector with colour of plotting symbols.}

\item{bg}{A vector with background colour of plotting symbols (only
used if \code{pch} in \code{21:25}).}

\item{col.common}{Colour of line representing common effect estimate.}

\item{col.random}{Colour of line representing random effects
estimate.}

\item{log}{A character string which contains \code{"x"} if the
x-axis is to be logarithmic, \code{"y"} if the y-axis is to be
logarithmic and \code{"xy"} or \code{"yx"} if both axes are to be
logarithmic.}

\item{yaxis}{A character string indicating which type of weights
are to be used. Either \code{"se"}, \code{"invvar"},
\code{"invse"}, code{"size"}, code{"invsqrtsize"}, or
code{"ess"}.}

\item{contour.levels}{A numeric vector specifying contour levels to
produce contour-enhanced funnel plot.}

\item{col.contour}{Colour of contours.}

\item{ref}{Reference value (null effect) used to produce
contour-enhanced funnel plot.}

\item{level}{The confidence level utilised in the plot. For the
funnel plot, confidence limits are not drawn if
\code{yaxis="size"} or \code{yaxis="invsqrtsize"}.}

\item{studlab}{A logical indicating whether study labels should be
printed in the graph. A vector with study labels can also be
provided (must be of same length as \code{x$TE} then).}

\item{cex.studlab}{Size of study labels, see argument \code{cex} in
\code{\link{text}}.}

\item{pos.studlab}{Position of study labels, see argument
\code{pos} in \code{\link{text}}.}

\item{ref.triangle}{A logical indicating whether approximate
confidence limits should be printed around reference value (null
effect).}

\item{lty.ref}{Line type (reference value).}

\item{lwd.ref}{The line width for the reference value and
corresponding confidence intervals (if \code{ref.triangle} is
TRUE and \code{level} is not \code{NULL}).}

\item{col.ref}{Colour of line representing reference value.}

\item{lty.ref.triangle}{Line type (confidence intervals of
reference value).}

\item{backtransf}{A logical indicating whether results for relative
summary measures (argument \code{sm} equal to \code{"OR"},
\code{"RR"}, \code{"HR"}, or \code{"IRR"}) should be back
transformed in funnel plots. If \code{backtransf=TRUE}, results
for \code{sm="OR"} are printed as odds ratios rather than log
odds ratios, for example.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).
moment).}
}
\description{
Draw a funnel plot which can be used to assess small study effects
in meta-analysis. A contour-enhanced funnel plot can also be
produced to assess causes of funnel plot asymmetry.
}
\details{
A funnel plot (Light & Pillemer, 1984) is drawn in the active
graphics window. If \code{common} is TRUE, the estimate of the
common effect model is plotted as a vertical line. Similarly, if
\code{random} is TRUE, the estimate of the random effects model is
plotted. If \code{level} is not NULL, the corresponding approximate
confidence limits are drawn around the common effect estimate (if
\code{common} is TRUE) or the random effects estimate (if
\code{random} is TRUE and \code{common} is FALSE).

In the funnel plot, the standard error of the treatment estimates
is plotted on the y-axis by default (\code{yaxis = "se"}) which is
likely to be the best choice (Sterne & Egger, 2001). Only exception
is meta-analysis of diagnostic test accuracy studies (Deeks et al.,
2005) where the inverse of the square root of the \emph{effective
study size} is used (\code{yaxis = "ess"}). Other possible choices
for \code{yaxis} are \code{"invvar"} (inverse of the variance),
\code{"invse"} (inverse of the standard error), \code{"size"}
(study size), and \code{"invsqrtsize"} (1 / sqrt(study size)).

If argument \code{yaxis} is not equal to \code{"size"},
\code{"invsqrtsize"} or \code{"ess"}, contour-enhanced funnel plots
can be produced (Peters et al., 2008) by specifying the contour
levels (argument \code{contour.levels}). By default (argument
\code{col.contour} missing), suitable gray levels will be used to
distinguish the contours. Different colours can be chosen by
argument \code{col.contour}.
}
\examples{
data(Olkin1995)
m1 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
  data = Olkin1995, subset = c(41, 47, 51, 59),
  studlab = paste(author, year),
  sm = "RR", method = "I")

oldpar <- par(mfrow = c(2, 2))

# Standard funnel plot
#
funnel(m1)

# Funnel plot with confidence intervals, common effect estimate and
# contours
#
cc <- funnel(m1, common = TRUE,
             level = 0.95, contour = c(0.9, 0.95, 0.99))$col.contour
legend(0.05, 0.05,
  c("0.1 > p > 0.05", "0.05 > p > 0.01", "< 0.01"), fill = cc)

# Contour-enhanced funnel plot with user-chosen colours
#
funnel(m1, common = TRUE,
  level = 0.95, contour = c(0.9, 0.95, 0.99),
  col.contour = c("darkgreen", "green", "lightgreen"),
  lwd = 2, cex = 2, pch = 16, studlab = TRUE, cex.studlab = 1.25)
legend(0.05, 0.05,
  c("0.1 > p > 0.05", "0.05 > p > 0.01", "< 0.01"),
  fill = c("darkgreen", "green", "lightgreen"))

par(oldpar)

}
\references{
Deeks JJ, Macaskill P, Irwig L (2005):
The performance of tests of publication bias and other sample size
effects in systematic reviews of diagnostic test accuracy was
assessed.
\emph{Journal of Clinical Epidemiology},
\bold{58}:882--93

Light RJ & Pillemer DB (1984):
\emph{Summing Up. The Science of Reviewing Research}.
Cambridge: Harvard University Press

Peters JL, Sutton AJ, Jones DR, Abrams KR, Rushton L (2008):
Contour-enhanced meta-analysis funnel plots help distinguish
publication bias from other causes of asymmetry.
\emph{Journal of Clinical Epidemiology},
\bold{61}, 991--6

Sterne JAC & Egger M (2001):
Funnel plots for detecting bias in meta-analysis: Guidelines on
choice of axis.
\emph{Journal of Clinical Epidemiology},
\bold{54}, 1046--55
}
\seealso{
\code{\link{metabias}}, \code{\link{metabin}},
  \code{\link{metagen}}, \code{\link{radial}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}, Petra
  Graham \email{pgraham@efs.mq.edu.au}
}
\keyword{hplot}
