% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metainf.R
\name{metainf}
\alias{metainf}
\title{Influence analysis in meta-analysis using leave-one-out method}
\usage{
metainf(x, pooled, sortvar)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{pooled}{A character string indicating whether a fixed effect
or random effects model is used for pooling. Either missing (see
Details), \code{"fixed"} or \code{"random"}, can be abbreviated.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}
}
\value{
An object of class \code{c("metainf", "meta")} with corresponding
\code{print}, and \code{forest} functions. The object is a list
containing the following components:
\item{TE, seTE}{Estimated treatment effect and standard error of
  pooled estimate in influence analysis.}
\item{lower, upper}{Lower and upper confidence interval limits.}
\item{statistic}{Statistic for test of overall effect.}
\item{pval}{P-value for test of overall effect.}
\item{studlab}{Study label describing omission of studies.}
\item{w}{Sum of weights from fixed effect or random effects model.}
\item{I2}{Heterogeneity statistic I\eqn{^2}.}
\item{Rb}{Heterogeneity statistic R\eqn{_b}.}
\item{tau}{Square-root of between-study variance.}
\item{df.hakn}{Degrees of freedom for test of treatment effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{sm}{Summary measure.}
\item{method}{Method used for pooling.}
\item{k}{Number of studies combined in meta-analysis.}
\item{pooled}{As defined above.}
\item{comb.fixed}{A logical indicating whether analysis is based on
  fixed effect model.}
\item{comb.random}{A logical indicating whether analysis is based
  on random effects model.}
\item{TE.fixed, seTE.fixed}{Value is \code{NA}.}
\item{TE.random, seTE.random}{Value is \code{NA}.}
\item{Q}{Value is \code{NA}.}
\item{level.comb}{The level used to calculate confidence intervals
  for pooled estimates.}
\item{hakn}{A logical indicating whether the method by Hartung and
  Knapp is used to adjust test statistics and confidence
  intervals.}
\item{adhoc.hakn}{A character string indicating whether \emph{ad
  hoc} variance correction should be used for Hartung-Knapp
  method.}
\item{method.tau}{A character string indicating which method is
  used to estimate the between-study variance \eqn{\tau^2}.}
\item{tau.preset}{Prespecified value for the square root of the
  between-study variance \eqn{\tau^2}.}
\item{TE.tau}{Overall treatment effect used to estimate the
  between-study variance \eqn{\tau^2}.}
\item{n.harmonic.mean}{Harmonic mean of number of observations (for
  back transformation of Freeman-Tukey Double arcsine
  transformation).}
\item{version}{Version of R package \bold{meta} used to create
  object.}
}
\description{
Performs an influence analysis. Pooled estimates are calculated
omitting one study at a time.
}
\details{
Performs a influence analysis; pooled estimates are calculated
omitting one study at a time. Studies are sorted according to
\code{sortvar}.

Information from object \code{x} is utilised if argument
\code{pooled} is missing. A fixed effect model is assumed
(\code{pooled="fixed"}) if argument \code{x$comb.fixed} is
\code{TRUE}; a random effects model is assumed
(\code{pooled="random"}) if argument \code{x$comb.random} is
\code{TRUE} and \code{x$comb.fixed} is \code{FALSE}.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac,
              data = Fleiss1993bin, studlab = study,
              sm = "RR", method = "I")
m1
metainf(m1)
metainf(m1, pooled = "random")

forest(metainf(m1))
forest(metainf(m1), layout = "revman5")
forest(metainf(m1, pooled = "random"))

metainf(m1, sortvar = study)
metainf(m1, sortvar = 7:1)

m2 <- update(m1, title = "Fleiss1993bin meta-analysis",
             backtransf = FALSE)
metainf(m2)

data(Fleiss1993cont)
m3 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
               data = Fleiss1993cont, sm = "SMD")
metainf(m3)

}
\references{
Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation
}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
