% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlsurv.R
\name{mlsurv}
\alias{mlsurv}
\title{Fit proportional hazards survival models}
\usage{
mlsurv(
  formula,
  distribution,
  df = NULL,
  powers = NULL,
  rcs = TRUE,
  data,
  from.null = NULL,
  ...
)
}
\arguments{
\item{formula}{A model formula, where the left-hand side is a \link[survival]{Surv} object.}

\item{distribution}{A parametric distribution for the baseline hazard.
Possible values are \code{exponential}, \code{weibull}, \code{gompertz}, \code{rp}, \code{logchazard}, and \code{loghazard}.
\code{rp} is equivalent to a \code{logchazard} model with restricted cubic splines (argument \code{rcs = TRUE}).}

\item{df}{Represents the number of degrees of freedom used for the restricted cubic splines when flexibly modelling the baseline hazard.
Only required when \code{rcs = TRUE}.}

\item{powers}{A vector representing the degree of the fractional polynomials used to model the baseline hazard (with a maximum degree of 2).
Only required when \code{rcs = FALSE}.}

\item{rcs}{Use restricted cubic splines when flexibly modelling the baseline hazard? Defaults to \code{TRUE}, and the alternative is using fractional polynomials.}

\item{data}{A data frame containing all variables required for fitting the model.
Can be a \code{tibble} object.}

\item{from.null}{A vector of starting values for the null model (used to get improved starting values). This is mostly useful when experiencing issues with default starting values or convergence issues.}

\item{...}{Further arguments passed to \link{merlin}.}
}
\value{
An object of class \code{mlsurv}.
}
\description{
Fit proportional hazards survival models
}
\examples{
# Weibull model
library(survival)
data("pbc.merlin", package = "merlin")
fit <- mlsurv(
  formula = Surv(stime, died) ~ trt,
  distribution = "weibull",
  data = pbc.merlin
)
summary(fit)

# Royston-Parmar model with 3 degrees of freedom
fit <- mlsurv(
  formula = Surv(stime, died) ~ trt,
  distribution = "rp",
  df = 3,
  data = pbc.merlin
)
summary(fit)

\dontrun{
# Flexible parametric model on the log-hazard scale with fractional polynomials
fit <- mlsurv(
  formula = Surv(stime, died) ~ trt,
  distribution = "loghazard",
  powers = c(0, 1),
  rcs = FALSE,
  data = pbc.merlin
)
summary(fit)
}
}
