% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merData.R
\name{averageObs}
\alias{averageObs}
\title{Find the average observation for a merMod object}
\usage{
averageObs(merMod, varList = NULL, origData = NULL, ...)
}
\arguments{
\item{merMod}{a merMod object}

\item{varList}{optional, a named list of conditions to subset the data on}

\item{origData}{(default=NULL) a data frame containing the original,
untransformed data used to call the model. This MUST be specified if
the original variables used in formula function calls are NOT present
as 'main effects'.}

\item{...}{not used currently}
}
\value{
a data frame with a single row for the average observation, but with full
factor levels. See details for more.
}
\description{
Extract a data frame of a single row that represents the
average observation in a merMod object. This function also allows the
user to pass a series of conditioning argument to calculate the average
observation conditional on other characteristics.
}
\details{
Each character and factor variable in the data.frame is assigned to the
modal category and each numeric variable is collapsed to the mean. Currently if
mode is a tie, returns a "." Uses the collapseFrame function.
}
