% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merExtract.R
\name{RMSE.merMod}
\alias{RMSE.merMod}
\title{Estimate the Root Mean Squared Error (RMSE) for a lmerMod}
\usage{
RMSE.merMod(merMod, scale = FALSE)
}
\arguments{
\item{merMod}{a lmerMod object from the lme4 package}

\item{scale}{logical, should the result be returned on the scale of
response variable standard deviations?}
}
\value{
a numeric which represents the RMSE
}
\description{
Extract the Root Mean Squared Error for a lmerMod object
}
\examples{
require(lme4)
m2 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
RMSE.merMod(m2)
}

