% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{network_stats}
\alias{network_stats}
\title{Network statistics}
\usage{
network_stats(adj, giant = FALSE, weights = NULL,
  mode = "undirected")
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix.}

\item{giant}{logical specifying whether the should be computed for the
largest component.}

\item{weights}{numeric vector of edge weights. Optional.}

\item{mode}{character, either \code{"directed"} or \code{"undirected"},
specifying whether the network should be interepeted as directed
or undirected. Defaults to \code{"undirected"}.}
}
\value{
A named numeric vector containing the computed network statistics.
}
\description{
Function computes various network measures including the size of the number of
nodes (|V|), the number of edges (|E|), the average degree (k),
uncorrected and corrected average local clustering (C, Cc), uncorrected and
corrected average shortest path lengths (L, Lc), the small-world index (S)
from Humphries & Gurney (2008), assortivity (A), and the size of largest
component (p) relative to the entire network.
}
\examples{

# get fluency data
data(animal_fluency)

# edge lists of fluency graphs
edge_list = threshold_graph(animal_fluency)

# get adjacency matrices
adj = edg_to_adj(edge_list)

# get structural overview
network_stats(adj)

}
