% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fluency}
\alias{fluency}
\title{Repeated verbal fluency generator.}
\usage{
fluency(adjlist, n, pjump = 0, type = 0L, string = FALSE)
}
\arguments{
\item{adjlist}{a list containing row indices of nodes adjacent node to the ith
node as created by \link{get_adjlist}.}

\item{n}{integer vector specifying for each sequence the number of
unique productions.}

\item{pjump}{numeric specifying the probability of a jump.}

\item{type}{integer controlling network start and jump nodes.
For \code{type = 0} the process selects the start node and any jump
nodes proportional to their degree. For \code{type = 1} the process
selects a random node to serve both as the start node and the jump node.
For \code{type = 2} the process selects the start and any jump nodes
uniformly at random.}

\item{string}{logical specifying whether the output should be of mode character.}
}
\value{
List of character vectors containing the indices of the fluency productions.
  Indices refer to the row of the item in the original adjacency matrix. See
  \link{get_adjlist}.
}
\description{
Generates multiple verbal fluency sequences using \link{one_fluency}.
}
\details{
For details see \link{one_fluency}.
}
\examples{
# generate watts strogatz graph
network = grow_ws(n = 100, k = 3)

# create verbal fluency sequences
fluency(get_adjlist(network), c(10, 10))

# create verbal fluency sequence
# with high jump probability
fluency(get_adjlist(network), c(10, 10), pjump = .5)

}
\references{
Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
differences in the semantic networks of younger and older adults.
https://doi.org/10.31234/osf.io/s73dp

Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
inspired mechanism for network exploration. International Journal of
Bifurcation and Chaos, 20(03), 913-922.
}
