% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grow_hk}
\alias{grow_hk}
\title{Holme and Kim (2002) network growth model}
\usage{
grow_hk(n = 100L, m = 5L, p = 5)
}
\arguments{
\item{n}{Integer. Number of nodes in the network.}

\item{m}{Integer. Number of edges added for each incoming node.}

\item{p}{Numeric. Proability that a triad formation step follows a preferential
attachment step.}
}
\value{
n x n adjacency matrix.
}
\description{
Grow networks using Holme & Kim's (2002) model, which combines preferential
attachment with tunable triad formation flexibly controlling the amount of
clustering in the network via \code{p}.
}
\examples{
# generate small graph
grow_hk(n = 6, m = 2, p = .1)

\dontrun{
# generate large graph, low clustering
grow_hk(n = 100, m = 10, p = .1)

# generate large graph, high clustering
grow_hk(n = 100, m = 10, p = .9)
}

}
\references{
Holme, P., & Kim, B. J. (2002). Growing scale-free networks with tunable
clustering. Physical review E, 65(2), 026107.
}
