% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ELMT-class}
\alias{ELMT-class}
\alias{ELMT}
\title{\linkS4class{ELMT} class}
\description{
S4 class for empirical likelihood multiple tests.
}
\section{Slots}{

\describe{
\item{\code{estimates}}{A list of numeric vectors of the estimates of the linear
hypotheses.}

\item{\code{statistic}}{A numeric vector of minus twice the (constrained) empirical
log-likelihood ratios with asymptotic chi-square distributions.}

\item{\code{df}}{An integer vector of the marginal degrees of freedom of the
statistic.}

\item{\code{pval}}{A numeric vector for the multiplicity adjusted \eqn{p}-values.}

\item{\code{cv}}{A single numeric for the multiplicity adjusted critical value.}

\item{\code{rhs}}{A numeric vector for the right-hand sides of the hypotheses.}

\item{\code{lhs}}{A numeric matrix for the left-hand side of the hypotheses.}

\item{\code{alpha}}{A single numeric for the overall significance level.}

\item{\code{calibrate}}{A single character for the calibration method used.}

\item{\code{weights}}{A numeric vector of the re-scaled weights used for the model
fitting.}

\item{\code{coefficients}}{A numeric vector of the maximum empirical likelihood
estimates of the parameters.}

\item{\code{method}}{A single character for the method dispatch in internal
functions.}

\item{\code{data}}{A numeric matrix of the data for the model fitting.}

\item{\code{control}}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}}

\examples{
showClass("ELMT")
}
