% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SD-class}
\alias{SD-class}
\alias{SD}
\title{\linkS4class{SD} class}
\description{
S4 class for standard deviation. It inherits from \linkS4class{EL} class.
}
\section{Slots}{

\describe{
\item{\code{optim}}{A list of the following optimization results:
\itemize{
\item \code{par} A numeric vector of the specified parameters.
\item \code{lambda} A numeric vector of the Lagrange multipliers of the dual
problem corresponding to \code{par}.
\item \code{iterations} A single integer for the number of iterations performed.
\item \code{convergence} A single logical for the convergence status.
\item \code{cstr} A single logical for whether constrained EL optimization is
performed or not.
}}

\item{\code{logp}}{A numeric vector of the log probabilities of the empirical
likelihood.}

\item{\code{logl}}{A single numeric of the empirical log-likelihood.}

\item{\code{loglr}}{A single numeric of the empirical log-likelihood ratio.}

\item{\code{statistic}}{A single numeric of minus twice the empirical log-likelihood
ratio with an asymptotic chi-square distribution.}

\item{\code{df}}{A single integer for the degrees of freedom of the statistic.}

\item{\code{pval}}{A single numeric for the \eqn{p}-value of the statistic.}

\item{\code{nobs}}{A single integer for the number of observations.}

\item{\code{npar}}{A single integer for the number of parameters.}

\item{\code{weights}}{A numeric vector of the re-scaled weights used for the model
fitting.}

\item{\code{coefficients}}{A numeric vector of the maximum empirical likelihood
estimates of the parameters.}

\item{\code{method}}{A single character for the method dispatch in internal
functions.}

\item{\code{data}}{A numeric matrix of the data for the model fitting.}

\item{\code{control}}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}}

\examples{
showClass("SD")
}
