% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coef-methods.R
\name{coef}
\alias{coef}
\alias{coef,EL-method}
\alias{coef,ELMT-method}
\title{Model coefficients}
\usage{
\S4method{coef}{EL}(object, ...)

\S4method{coef}{ELMT}(object, ...)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL} or
\linkS4class{ELMT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
The form of the value returned by [coef()] depends on the class of
  its argument.
}
\description{
Extracts maximum empirical likelihood estimates from a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{coef(EL)}: Extracts the numeric vector of the maximum empirical
likelihood estimates.

\item \code{coef(ELMT)}: Extracts the list of numeric vectors of the maximum
empirical likelihood estimates. Each element of the list corresponds to a
distinct hypothesis.

}}
\examples{
data("mtcars")
fit <- el_lm(mpg ~ wt, data = mtcars)
coef(fit)
}
\seealso{
\linkS4class{EL}, \linkS4class{ELMT}
}
