% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elt-methods.R
\name{elt}
\alias{elt}
\alias{elt,EL-method}
\alias{elt,QGLM-method}
\alias{elt,SD-method}
\alias{elt,missing-method}
\title{Empirical likelihood test}
\usage{
\S4method{elt}{EL}(
  object,
  rhs = NULL,
  lhs = NULL,
  alpha = 0.05,
  calibrate = "chisq",
  control = el_control()
)
}
\arguments{
\item{object}{An object that inherit from \linkS4class{EL}, including
\linkS4class{CEL}, \linkS4class{LM}, and \linkS4class{GLM}.}

\item{rhs}{A numeric vector or a column matrix for the right-hand side of
hypothesis, with as many entries as the rows in \code{lhs}. Defaults to \code{NULL}.
See ‘Details’.}

\item{lhs}{A numeric matrix or a vector (treated as a row matrix) for the
left-hand side of hypothesis. Each row gives a linear combination of the
parameters in \code{object}. The number of columns should be equal to the number
of parameters. Defaults to \code{NULL}. See ‘Details’.}

\item{alpha}{A single numeric for the significance level. Defaults to \code{0.05}.}

\item{calibrate}{A single character for the calibration method. It is
case-insensitive and must be one of \code{"chisq"}, \code{"boot"}, or \code{"f"}.
Defaults to \code{"chisq"}. See ‘Details’.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}
\value{
An object of class of \linkS4class{ELT}. If \code{lhs} is non-\code{NULL}, the
\code{optim} slot corresponds to that of \linkS4class{CEL}. Otherwise, it
corresponds to that of \linkS4class{EL}.
}
\description{
Tests a linear hypothesis.
}
\details{
\code{\link[=elt]{elt()}} performs the constrained minimization of \eqn{l(\theta)}
described in \linkS4class{CEL}. \code{rhs} and \code{lhs} cannot be both \code{NULL}. For
non-\code{NULL} \code{lhs}, it is required that \code{lhs} have full row rank
\eqn{q \leq p} and \eqn{p} be equal to the number of parameters in the
\code{object}.

Depending on the specification of \code{rhs} and \code{lhs}, we have the following
three cases:
\enumerate{
\item If both \code{rhs} and \code{lhs} are non-\code{NULL}, the constrained minimization
is performed with the right-hand side \eqn{r} and the left-hand side
\eqn{L} as
\deqn{\inf_{\theta: L\theta = r} l(\theta).}
\item If \code{rhs} is \code{NULL}, \eqn{r} is set to the zero vector as
\eqn{\inf_{\theta: L\theta = 0} l(\theta)}.
\item If \code{lhs} is \code{NULL}, \eqn{L} is set to the identity matrix and the
problem reduces to evaluating at \eqn{r} as \eqn{l(r)}.
}

\code{calibrate} specifies the calibration method used. Three methods are
available: \code{"chisq"} (chi-square calibration), \code{"boot"} (bootstrap
calibration), and \code{"f"} (\eqn{F} calibration). \code{"boot"} is applicable only
when \code{lhs} is \code{NULL}. The \code{nthreads}, \code{seed}, and \code{B} slots in \code{control}
apply to the bootstrap procedure. \code{"f"} is applicable only to the mean
parameter when \code{lhs} is \code{NULL}.
}
\examples{
## F calibration for the mean
set.seed(533414)
x <- rnorm(100)
fit <- el_mean(x, 0)
elt(fit, rhs = 0.3, calibrate = "f")

## Test of no treatment effect
data("clothianidin")
lhs <- matrix(c(
  1, -1, 0, 0,
  0, 1, -1, 0,
  0, 0, 1, -1
), byrow = TRUE, nrow = 3)
fit2 <- el_lm(clo ~ -1 + trt, clothianidin)
elt(fit2, lhs = lhs)
}
\references{
Adimari G, Guolo A (2010).
“A Note on the Asymptotic Behaviour of Empirical Likelihood Statistics.”
Statistical Methods & Applications, 19(4), 463–476.
\doi{10.1007/s10260-010-0137-9}.

Qin J, Lawless J (1995).
“Estimating Equations, Empirical Likelihood and Constraints on Parameters.”
Canadian Journal of Statistics, 23(2), 145–159. \doi{10.2307/3315441}.
}
\seealso{
\code{\link[=el_control]{el_control()}}, \code{\link[=elmt]{elmt()}}
}
