% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/weights-methods.R
\name{weights}
\alias{weights}
\alias{weights,EL-method}
\title{Model weights}
\usage{
\S4method{weights}{EL}(object, ...)
}
\arguments{
\item{object}{An object that inherit from \linkS4class{EL}, including
\linkS4class{CEL}, \linkS4class{LM}, and \linkS4class{GLM}.}

\item{...}{Further arguments passed to methods.}
}
\value{
A numeric vector of the re-scaled weights.
}
\description{
Extracts weights from model objects. The weights are re-scaled to up to the
total number of observations in the fitting procedure.
}
\examples{
data("airquality")
x <- airquality$Wind
w <- airquality$Day
fit <- el_mean(x, par = 10, weights = w)
weights(fit)
}
\references{
Glenn N, Zhao Y (2007).
“Weighted Empirical Likelihood Estimates and Their Robustness Properties.”
Computational Statistics & Data Analysis, 51(10), 5130–5141.
\doi{10.1016/j.csda.2006.07.032}.
}
