% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{el_test}
\alias{el_test}
\title{Tests single hypothesis for general block designs}
\usage{
el_test(formula, data, lhs, rhs = NULL, maxit = 10000, abstol = 1e-08)
}
\arguments{
\item{formula}{A formula object. It must specify variables for response,
treatment, and block as 'response ~ treatment | block'. Note that the use
of vertical bar (|) separating treatment and block.}

\item{data}{A data frame containing the variables in the formula.}

\item{lhs}{Numeric matrix specifying linear hypothesis in terms of
parameters.}

\item{rhs}{Optional numeric vector for the right hand side of \code{lhs}.
If not specified, it is set to 0 vector.}

\item{maxit}{Maximum number of iterations for optimization.
Defaults to 10000.}

\item{abstol}{Absolute convergence tolerance for optimization.
Defaults to 1e-08.}
}
\value{
A list of class \code{c("el_test", "melt")}.
}
\description{
\emph{This function is deprecated in favor of \link{lht} and will be
  removed in a future release.}
}
\examples{
\dontrun{
# test of no treatment effect
data("clothianidin")
el_test(clo ~ trt | blk, clothianidin,
  lhs = matrix(c(
    1, -1, 0, 0,
    0, 1, -1, 0,
    0, 0, 1, -1
  ), byrow = TRUE, nrow = 3)
)
}
}
\references{
Kim, E., MacEachern, S., and Peruggia, M., (2021),
"Empirical Likelihood for the Analysis of Experimental Designs,"
\href{https://arxiv.org/abs/2112.09206}{arxiv:2112.09206}.
}
