% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_lm.R
\name{el_lm}
\alias{el_lm}
\title{Fit a Linear Model with Empirical Likelihood}
\usage{
el_lm(formula, data, na.action, model = TRUE, maxit = 10000, abstol = 1e-08)
}
\arguments{
\item{formula}{A formula object.}

\item{data}{A data frame containing the variables in the formula.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{model}{Logical. If TRUE the model frame is returned.}

\item{maxit}{Maximum number of iterations for optimization. Defaults to 10000.}

\item{abstol}{Absolute convergence tolerance for optimization. Defaults to 1e-08.}
}
\value{
A list with class \code{c("el_lm", "melt")}.
}
\description{
Fit a linear model with empirical likelihood.
}
\examples{
model <- el_lm(clo ~ trt, clothianidin)
summary(model)
}
\references{
Owen, Art. 1991. “Empirical Likelihood for Linear Models.” The Annals of Statistics 19 (4). \doi{10.1214/aos/1176348368}.
}
\seealso{
\link{el_aov}
}
