% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9cm.R
\name{icd9cm_rcri}
\alias{icd9cm_rcri}
\title{Create Map of ICD-9-CM to Revised Cardiac Risk Index classes}
\usage{
icd9cm_rcri(icd9)
}
\arguments{
\item{icd9}{a unique character vector of ICD-9-CM codes}
}
\value{
A data frame, with ICD9 codes as row names and logical columns for
\code{chf}, \code{cvd}, \code{dm}, \code{ischemia}, and \code{renlfail}.
}
\description{
Function to generate data frame that links ICD-9-CM codes to the RCRI comorbidity categories.
}
\details{
Lee et al in 1999 published a "Revised Cardiac Risk Index" based on the work 
on Goldman in 1997. The RCRI is used to determine the major cardiac 
complication risk for a patient about to undergo major noncardiac surgery. 
The six predictors that make up the RCRI are: 1. high-risk surgery 2. history
of ischemic heart disease 3. history of congestive heart failure 4. history 
of cerebrovascular disease 5. preoperative treatment with insulin 6. 
preoperative serum creatinine with Cr > 2 mg/dL.

In 2005 Boersma et al demonstrated that the Lee indexed can be adapted to use
administrative data to predict cardiovascular mortality.  They used the 
following for each point above: 1. retroperitoneal, intrathoracic, or 
suprainguinal vascular procedure; 2. Ischemia: ICD-9 codes 410.*, 411.*, 
412.*, 413.*, 414.*; 3. CVA: ICD-9 428.*; 4. CHF: ICD-9 943.0; 5. DM: ICD-9 
425.0; 6. Renal: ICD-9 958.0.

This function merges the ICD-9 guidelines 
used by Boersma with some of the other ICD-9 classifiers in this package. 
This data set uses the following for each aspect of the RCRI:
1. procedure is left to you
2. 'ischemia' as defined in Boersma
3. 'cvd' as defined by Quan in \code{\link{icd9cm_charlson_quan}}
4. 'chf' as defined by AHRQ in \code{\link{icd9cm_elixhauser_ahrq37}}
5. 'dm' as  defined by AHRQ (both 'dm' and 'dmcx')
6. renlfail' as defined by AHRQ.
}
\references{
1. Lee TH, Marcantonio ER, Mangione CM, Thomas EJ, Polanczyk CA, 
  Cook EF, Sugarbaker DJ, Donaldson MC, Poss R, Ho KK, Ludwig LE, Pedan A, 
  Goldman L: Derivation and prospective validation of a simple index for 
  prediction of cardiac risk of major noncardiac surgery. Circulation 1999; 
  100:1043-9 \url{http://www.ncbi.nlm.nih.gov/pubmed/10477528}
  
  2. Boersma E, Kertai MD, Schouten O, Bax JJ, Noordzij P, Steyerberg EW, 
  Schinkel AFL, Santen M van, Simoons ML, Thomson IR, Klein J, Urk H van, 
  Poldermans D: Perioperative cardiovascular mortality in noncardiac surgery:
  validation of the Lee cardiac risk index. The American journal of medicine 
  2005; 118:1134-41 \url{http://www.ncbi.nlm.nih.gov/pubmed/16194645}
}
\seealso{
\code{\link{icd9cm_charlson_quan}}, \code{\link{icd9cm_elixhauser_quan}}, 
   \code{\link{icd9cm_elixhauser_ahrq37}}
}

