% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot_summary}
\alias{plot_summary}
\title{Displays spatial simulation summaries}
\usage{
plot_summary(x, variable, date, r = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{sf}, with simulation summaries.}

\item{variable}{The variable to be drawn.}

\item{date}{The date of the summary to be plotted.}

\item{r}{An object of class \code{\link{rast}}, defining the raster topology.}

\item{...}{Additional parameters (passed to scale definition, such as \code{limits}).}
}
\value{
An object of class \code{\link{ggplot}}.
}
\description{
Produces graphical output of the summaries of a simulation models
}
\details{
Appropriate values for \code{x} can originate from calls to \code{\link{simulation_summary}}.
Alternatively, if summary functions were specified at the time of performing simulations,
the result of the spatial simulation function (e.g. \code{\link{spwb_spatial}})
will already contain the summaries. A special case is made for \code{\link{spwb_land}} and \code{\link{growth_land}},
that are accepted inputs as \code{x}, because its element 'sf' is used.
}
\seealso{
\code{\link{spwb_spatial}}, \code{\link{simulation_summary}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.
}
