% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_variables.R
\name{extract_variables}
\alias{extract_variables}
\alias{plot_variable}
\title{Landscape variables}
\usage{
extract_variables(x, vars = "land_cover_type", SpParams = NULL, ...)

plot_variable(x, variable = "land_cover_type", SpParams = NULL, r = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link{sf}} with the appropriate columns.}

\item{vars}{A string vector with the name of the variables to extract (see details).}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}), required for most forest stand variables.}

\item{...}{Additional arguments (not used).}

\item{variable}{A string with the name of the variables to draw (see details).}

\item{r}{An object of class \code{\link{rast}}, defining the raster topology.}
}
\value{
Function \code{extract_variables()} returns an object of class \code{\link{sf}} with the desired variables.
Function \code{plot_variables()} returns a ggplot object.
}
\description{
Extract or estimate variables from landscape objects (class 'sf').
}
\details{
The following string values are available for \code{vars}.

\emph{Topography}:
\itemize{
\item{\code{"elevation"}: Elevation in m.}
\item{\code{"slope"}: Slope in degrees.}
\item{\code{"aspect"}: Slope in degrees.}
\item{\code{"land_cover_type"}: Land cover type.}
}

\emph{Soil}:
\itemize{
\item{\code{"soil_vol_extract"}: Total water extractable volume (mm).}
\item{\code{"soil_vol_sat"}: Total water volume at saturation (mm).}
\item{\code{"soil_vol_fc"}: Total water volume at field capacity (mm).}
\item{\code{"soil_vol_wp"}: Total water volume at wilting point (mm).}
\item{\code{"soil_vol_curr"}: Current total water volume (mm).}
\item{\code{"soil_rwc_curr"}: Current soil relative water content (\%).}
\item{\code{"soil_rew_curr"}: Current soil relative extractable water (\%).}
\item{\code{"soil_theta_curr"}: Current soil moisture content (\% vol.)}
\item{\code{"soil_psi_curr"}: Current soil water potential (MPa).}
}

\emph{Watershed}:
\itemize{
\item{\code{"depth_to_bedrock"}: Depth to bedrock (m).}
\item{\code{"bedrock_porosity"}: Bedrock porosity.}
\item{\code{"bedrock_conductivity"}: Bedrock conductivity (m/day).}
\item{\code{"aquifer_elevation"}: Aquifer elevation over bedrock (m).}
\item{\code{"depth_to_aquifer"}: Depth to aquifer (m).}
\item{\code{"aquifer"}: Aquifer volume (mm).}
\item{\code{"snowpack"}: Snowpack water equivalent (mm).}
}

\emph{Forest stand}:
\itemize{
\item{\code{"basal_area"}: Basal area (m2/ha).}
\item{\code{"tree_density"}: Tree density (ind/ha).}
\item{\code{"mean_tree_height"}: Mean tree height (cm).}
\item{\code{"dominant_tree_height"}: Dominant tree height (cm).}
\item{\code{"dominant_tree_diameter"}: Dominant tree diameter (cm).}
\item{\code{"quadratic_mean_tree_diameter"}: Quadratic mean tree diameter (cm).}
\item{\code{"hart_becking_index"}: Hart-Becking index.}
\item{\code{"leaf_area_index"}: Leaf area index (m2/m2).}
\item{\code{"foliar_biomass"}: Foliar biomass (kg/m2).}
\item{\code{"fuel_loading"}: Fine live fuel loading (kg/m2).}
\item{\code{"shrub_volume"}: Shrub volume (m3/m2).}
}
}
\examples{
# Load data and species parameters from medfate
data(example_ifn)
data(SpParamsMED)
  
# Calculate basal area and leaf area index
# for all forest stands
extract_variables(example_ifn, vars = c("basal_area", "leaf_area_index"),
                  SpParams = SpParamsMED)
                  
}
\seealso{
\code{\link{forest}}, \code{\link{soil}}, \code{\link{summary.forest}}, \code{\link{shinyplot_land}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.
}
