% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hydrology_soilEvaporationAmount}
\alias{hydrology_soilEvaporationAmount}
\alias{hydrology_soilEvaporation}
\alias{hydrology_herbaceousTranspiration}
\title{Bare soil evaporation and herbaceous transpiration}
\usage{
hydrology_soilEvaporationAmount(DEF, PETs, Gsoil)

hydrology_soilEvaporation(
  soil,
  snowpack,
  soilFunctions,
  pet,
  LgroundSWR,
  modifySoil = TRUE
)

hydrology_herbaceousTranspiration(
  pet,
  LherbSWR,
  herbLAI,
  soil,
  soilFunctions,
  modifySoil = TRUE
)
}
\arguments{
\item{DEF}{Water deficit in the (topsoil) layer.}

\item{PETs}{Potential evapotranspiration at the soil surface.}

\item{Gsoil}{Gamma parameter (maximum daily evaporation).}

\item{soil}{An object of class \code{\link{soil}}.}

\item{snowpack}{The amount of snow (in water equivalents, mm) in the snow pack.}

\item{soilFunctions}{Soil water retention curve and conductivity functions, either 'SX' (for Saxton) or 'VG' (for Van Genuchten).}

\item{pet}{Potential evapotranspiration for a given day (mm)}

\item{LgroundSWR}{Percentage of short-wave radiation (SWR) reaching the ground.}

\item{modifySoil}{Boolean flag to indicate that the input \code{soil} object should be modified during the simulation.}

\item{LherbSWR}{Percentage of short-wave radiation (SWR) reaching the herbaceous layer.}

\item{herbLAI}{Leaf area index of the herbaceous layer.}
}
\value{
Function \code{hydrology_soilEvaporationAmount} returns the amount of water evaporated from the soil. 

Function \code{hydrology_soilEvaporation} returns a vector of water evaporated from each soil layer.
}
\description{
Functions:
\itemize{
  \item{Function \code{hydrology_soilEvaporationAmount} calculates the amount of evaporation from bare soil, following Ritchie (1972).}
  \item{Function \code{hydrology_soilEvaporation} calculates the amount of evaporation from bare soil and distributes it among soil layers.}
  \item{Function \code{hydrology_herbaceousTranspiration} calculates the amount of transpiration due to herbaceous plants.}
}
}
\references{
Ritchie (1972). Model for predicting evaporation from a row crop with incomplete cover. - Water resources research.
}
\seealso{
\code{\link{spwb}}, \code{\link{hydrology_waterInputs}}, \code{\link{hydrology_infiltration}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
