% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulnerability.R
\name{vulnerability}
\alias{vulnerability}
\title{Calculate the vulnerability of each node for each network}
\usage{
vulnerability(network_list)
}
\arguments{
\item{network_list}{a list with multiple networks; all the networks should be trans_network object created from \code{\link{trans_network}} class of \code{microeco} package.}
}
\value{
data.frame
}
\description{
The vulnerability of each node represents the influence of the node on the global efficiency of the network, i.e. the efficiency of network after removing the targeted node.
For the detailed defination of global efficiency, please see the "Eff" option of measure parameter in \code{\link{robustness}} class.
}
\examples{
\donttest{
data(soil_amp_network)
vulnerability_table <- vulnerability(soil_amp_network)
}
}
