% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_table.R
\name{mean_table}
\alias{mean_table}
\title{Estimate Mean and 95 Percent Confidence Intervals in dplyr Pipelines}
\usage{
mean_table(.data, x, t_prob = 0.975, output = default, digits = 2, ...)
}
\arguments{
\item{.data}{A tibble or grouped tibble.}

\item{x}{The continuous response variable for which the statistics are
desired.}

\item{t_prob}{(1 - alpha / 2). Default value is 0.975, which corresponds to
an alpha of 0.05. Used to calculate a critical value from Student's t
distribution with n - 1 degrees of freedom.}

\item{output}{Options for this parameter are "default" and "all".

  Default output includes the n, mean, sem, and 95% confidence interval for
  the mean. Using output = "all" also returns the the number of missing
  values for x and the critical t-value.}

\item{digits}{Round mean, lcl, and ucl to digits. Default is 2.}

\item{...}{Other parameters to be passed on.}
}
\value{
A tibble of class "mean_table" or "mean_table_grouped"
}
\description{
The mean_table function produces overall and grouped
  tables of means with related statistics. In addition to means, the
  mean_table missing/non-missing frequencies, the standared error of the
  mean (sem), the 95% confidence intervals for the mean(s), the minimum
  value, and the maximum value. For grouped tibbles, mean_table displays
  these statistics for each category of the group_by variable.
}
\examples{
library(dplyr)
library(meantables)

data(mtcars)

# Overall mean table with defaults

mtcars \%>\%
  mean_table(mpg)

#> # A tibble: 1 x 8
#>   response_var     n  mean      sem   lcl   ucl   min   max
#>          <chr> <int> <dbl>    <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1          mpg    32 20.09 1.065424 17.92 22.26  10.4  33.9

# Grouped means table with defaults

mtcars \%>\%
  group_by(cyl) \%>\%
  mean_table(mpg)

#> # A tibble: 3 x 10
#>   response_var group_var group_cat     n  mean       sem   lcl   ucl   min   max
#>          <chr>     <chr>     <dbl> <int> <dbl>     <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1          mpg       cyl         4    11 26.66 1.3597642 23.63 29.69  21.4  33.9
#> 2          mpg       cyl         6     7 19.74 0.5493967 18.40 21.09  17.8  21.4
#> 3          mpg       cyl         8    14 15.10 0.6842016 13.62 16.58  10.4  19.2
}
\references{
SAS documentation: http://support.sas.com/documentation/cdl/en/proc/65145/HTML/default/viewer.htm#p0klmrp4k89pz0n1p72t0clpavyx.htm
}
