% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepCMssForGGplot.R
\name{prepCMssForGGplot}
\alias{prepCMssForGGplot}
\title{Prepare consensus matrices for ggplot}
\usage{
prepCMssForGGplot(cms, model_description_df, matrix_setting_order = NULL)
}
\arguments{
\item{cms}{List of similarity matrices of common size.}

\item{model_description_df}{A data.frame with as many rows as ``cms`` has
entries with a common ordering. Each row is expected to contain the
width/number of chains used in constructing the corresponding consensus
matrix and the depth/iteration from each chain that is used. The column names
should be ``Depth`` and ``Width``.}

\item{matrix_setting_order}{The index for the consensus matrix that defines
the ordering of entries for the heatmap. Defaults to the final entry in
``cms``.}
}
\value{
Returns a data frame of the entries from consensus matrices (``cms``)
annotated by the details of the ensemble run (i.e., number of chains, chain 
depth, given in ``model_description_df``), in the appropriate format to be 
plotted as a set of heatmap facets in a ggplot2 object.
}
\description{
Converts a list of consensus matrices into a long data.frame
ready for ggplot2. The matrices are given a common ordering defined by the
list entry in index ``matrix_setting_order``, this is the ``x`` and ``y``
entry in the output and is used in the ``ggplot2`` geom, ``geom_tile``, as
the ``x`` and ``y`` aesthetics.  The description of the ensembles generating
the matrices is given in ``model_description_df`` and is used to annotate the
matrices.
}
\examples{
\donttest{
model_description_df <- data.frame(
  "Depth" = rep(c(100, 500, 1000), 3),
  "Width" = c(rep(50, 3), rep(100, 3), rep(200, 3))
)
n_models <- nrow(model_description_df)
cms <- vector("list", n_models)
for (ii in seq(1, n_models)) {
  cms[[ii]] <- createSimilarityMat(mcmc[[ii]]$allocations)
}
plot_df <- prepCMssForGGplot(cms, model_description_df)
plot_df |>
  ggplot2::ggplot(ggplot2::aes(x = x, y = y, fill = Entry)) +
  ggplot2::geom_tile() +
  ggplot2::facet_grid(Depth ~ Width, labeller = label_both()) +
  ggplot2::scale_fill_gradient(low = "#FFFFFF", high = "#146EB4")
}

}
