/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.scrollabledesktop;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ResizableToolBar
extends JToolBar
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int minButtonWidth;
    private int maxButtonWidth;

    public ResizableToolBar(int n, int n2) {
        this.setFloatable(false);
        this.minButtonWidth = n;
        this.maxButtonWidth = n2;
        this.addComponentListener(this);
    }

    public void add(AbstractButton abstractButton) {
        this.buttonGroup.add(abstractButton);
        super.add(abstractButton);
        abstractButton.setSelected(true);
        this.resizeButtons();
    }

    public void remove(AbstractButton abstractButton) {
        super.remove(abstractButton);
        this.buttonGroup.remove(abstractButton);
        this.resizeButtons();
        this.repaint();
    }

    public Enumeration<AbstractButton> getElements() {
        return this.buttonGroup.getElements();
    }

    public int getButtonCount() {
        return this.buttonGroup.getButtonCount();
    }

    private void resizeButtons() {
        final float f = this.getCurrentButtonWidth();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JToggleButton jToggleButton = null;
                Enumeration<AbstractButton> enumeration = ResizableToolBar.this.getElements();
                float f2 = 0.0f;
                while (enumeration.hasMoreElements()) {
                    jToggleButton = (JToggleButton)enumeration.nextElement();
                    int n = Math.round(f2 + f) - Math.round(f2);
                    ResizableToolBar.this.assignWidth(jToggleButton, n);
                    f2 += f;
                }
                ResizableToolBar.this.revalidate();
            }
        });
    }

    private float getCurrentButtonWidth() {
        int n = this.getWidth() - this.getInsets().left - this.getInsets().right;
        float f = n <= 0 ? this.maxButtonWidth : n;
        int n2 = this.getButtonCount();
        if (n2 > 0) {
            f /= (float)n2;
        }
        if (f < (float)this.minButtonWidth) {
            f = this.minButtonWidth;
        } else if (f > (float)this.maxButtonWidth) {
            f = this.maxButtonWidth;
        }
        return f;
    }

    private void assignWidth(JToggleButton jToggleButton, int n) {
        jToggleButton.setMinimumSize(new Dimension(n - 2, jToggleButton.getPreferredSize().height));
        jToggleButton.setPreferredSize(new Dimension(n, jToggleButton.getPreferredSize().height));
        Dimension dimension = jToggleButton.getPreferredSize();
        jToggleButton.setMaximumSize(dimension);
        jToggleButton.setSize(dimension);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.resizeButtons();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

