/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.children;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import multidendrograms.definitions.Formats;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.utils.FontUtils;

public class FontSelection
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Font font;
    private final Font initFont;
    private JComboBox cbSizes;
    private JComboBox cbFonts;
    private JCheckBox chkBold;
    private JCheckBox chkItalic;
    private final JButton btnAccept;
    private final JButton btnCancel;
    private JLabel lblSelectedFont;

    private void initialize() {
        String[] stringArray = new String[]{"6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20"};
        this.cbSizes = new JComboBox<String>(stringArray);
        this.cbSizes.setEditable(true);
        this.cbSizes.setSelectedItem(String.valueOf(this.font.getSize()));
        this.cbSizes.setFont(FontUtils.addStyle(InitialProperties.getFontLabel(), 1));
        String[] stringArray2 = FontSelection.getSystemFonts();
        this.cbFonts = new JComboBox<String>(stringArray2);
        this.cbFonts.setSelectedItem(this.font.getName());
        this.cbFonts.setFont(FontUtils.addStyle(InitialProperties.getFontLabel(), 1));
        this.chkBold = Formats.getFormattedCheckBox(Language.getLabel(54));
        this.chkBold.setSelected(this.font.isBold());
        this.chkItalic = Formats.getFormattedCheckBox(Language.getLabel(55));
        this.chkItalic.setSelected(this.font.isItalic());
        this.lblSelectedFont = new JLabel(Language.getLabel(57));
        this.lblSelectedFont.setAlignmentX(0.0f);
        this.lblSelectedFont.setFont(this.font);
    }

    private static String[] getSystemFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }

    public FontSelection(Font font) {
        this.setTitle(Language.getLabel(58));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.font = font;
        this.initFont = font;
        this.initialize();
        Container container = this.getContentPane();
        this.setLayout(new GridBagLayout());
        ((JPanel)container).setBorder(Formats.getFormattedTitledBorder(Language.getLabel(59)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblSelectedFont, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        this.cbFonts.addActionListener(this);
        container.add((Component)this.cbFonts, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.cbSizes.addActionListener(this);
        container.add((Component)this.cbSizes, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.chkBold.addActionListener(this);
        container.add((Component)this.chkBold, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.chkItalic.addActionListener(this);
        container.add((Component)this.chkItalic, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = -1;
        this.btnAccept = Formats.getFormattedBoldButton(Language.getLabel(60));
        this.btnAccept.addActionListener(this);
        container.add((Component)this.btnAccept, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        this.btnCancel = Formats.getFormattedBoldButton(Language.getLabel(61));
        this.btnCancel.addActionListener(this);
        container.add((Component)this.btnCancel, gridBagConstraints);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(Language.getLabel(60))) {
            this.font = this.giveFont();
            this.dispose();
        } else if (actionEvent.getActionCommand().equals(Language.getLabel(61))) {
            this.font = this.initFont;
            this.dispose();
        } else {
            this.font = this.giveFont();
            this.lblSelectedFont.setFont(this.font);
        }
    }

    public Font getNewFont() {
        return this.font;
    }

    private Font giveFont() {
        int n = 0;
        int n2 = Integer.valueOf((String)this.cbSizes.getSelectedItem());
        if (this.chkItalic.isSelected()) {
            n = 2;
        }
        if (this.chkBold.isSelected()) {
            ++n;
        }
        if (n == 0) {
            n = 0;
        }
        String string = (String)this.cbFonts.getSelectedItem();
        return new Font(string, n, n2);
    }
}

