/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.data;

import java.util.Hashtable;
import java.util.LinkedList;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.data.DataFile;
import multidendrograms.data.ProximityPair;
import multidendrograms.data.ReadTxt;
import multidendrograms.initial.LogManager;

public class ExternalData {
    private final DataFile dataFile;
    LinkedList<ProximityPair<String>> proximityPairs;
    private int numElements = 0;
    private SymmetricMatrix proximityMatrix;
    private Hashtable<String, Integer> hashNames;
    private LinkedList<String> names;

    public ExternalData(DataFile dataFile) throws Exception {
        this.dataFile = new DataFile(dataFile);
        ReadTxt readTxt = new ReadTxt(dataFile.getPathName());
        this.proximityPairs = readTxt.getData();
        this.numElements = readTxt.getNumElements();
        LogManager.LOG.config("Creating a matrix for " + this.numElements + " elements");
        this.proximityMatrix = new SymmetricMatrix(this.numElements);
        this.hashNames = new Hashtable();
        this.names = new LinkedList();
        int n = 0;
        for (ProximityPair proximityPair : this.proximityPairs) {
            int n2;
            int n3;
            String string = (String)proximityPair.getElement1();
            if (this.hashNames.containsKey(string)) {
                n3 = this.hashNames.get(string);
            } else {
                n3 = n++;
                this.hashNames.put(string, n3);
                this.names.add(string);
            }
            String string2 = (String)proximityPair.getElement2();
            if (this.hashNames.containsKey(string2)) {
                n2 = this.hashNames.get(string2);
            } else {
                n2 = n++;
                this.hashNames.put(string2, n2);
                this.names.add(string2);
            }
            double d = proximityPair.getProximity();
            this.proximityMatrix.setElement(n3, n2, d);
        }
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public SymmetricMatrix getProximityMatrix() {
        return this.proximityMatrix;
    }

    public LinkedList<ProximityPair<String>> getData() {
        return this.proximityPairs;
    }

    public int getPrecision() {
        return this.proximityMatrix.getPrecision();
    }
}

