/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.definitions;

import java.util.Arrays;

public class SymmetricMatrix {
    private double[] diagonal;
    private double[] lowerTriangle;
    private double minValue = Double.POSITIVE_INFINITY;
    private double maxValue = Double.NEGATIVE_INFINITY;
    private int maxDecimals = 0;

    public SymmetricMatrix(double[] dArray) {
        int n = dArray.length;
        int n2 = (1 + (int)Math.sqrt(1 + 8 * n)) / 2;
        this.diagonal = new double[n2];
        Arrays.fill(this.diagonal, Double.NaN);
        this.lowerTriangle = dArray;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            this.minValue = Math.min(this.minValue, d);
            this.maxValue = Math.max(this.maxValue, d);
            this.countDecimals(d);
        }
    }

    public SymmetricMatrix(double d) {
        this(new double[]{d});
    }

    public SymmetricMatrix(int n) {
        this.diagonal = new double[n];
        Arrays.fill(this.diagonal, Double.NaN);
        int n2 = (n - 1) * n / 2;
        this.lowerTriangle = new double[n2];
        Arrays.fill(this.lowerTriangle, Double.NaN);
    }

    public void setElement(int n, int n2, double d) {
        if (n == n2) {
            this.diagonal[n] = d;
        } else {
            int n3 = n > n2 ? this.getIndex(n, n2) : this.getIndex(n2, n);
            this.lowerTriangle[n3] = d;
            this.minValue = Math.min(this.minValue, d);
            this.maxValue = Math.max(this.maxValue, d);
        }
        this.countDecimals(d);
    }

    private void countDecimals(double d) {
        double d2;
        long l;
        if (!Double.isNaN(d) && (double)(l = Math.round(d2 = Math.abs(d))) != d2) {
            String string = String.valueOf(d2);
            String string2 = String.valueOf(l);
            int n = string.length() - string2.length() - 1;
            this.maxDecimals = Math.max(this.maxDecimals, n);
        }
    }

    public double getElement(int n, int n2) {
        if (n == n2) {
            return this.diagonal[n];
        }
        int n3 = n > n2 ? this.getIndex(n, n2) : this.getIndex(n2, n);
        return this.lowerTriangle[n3];
    }

    private int getIndex(int n, int n2) {
        int n3 = this.diagonal.length;
        return (2 * n3 - n2 - 1) * n2 / 2 + n - n2 - 1;
    }

    public int numberOfRows() {
        return this.diagonal.length;
    }

    public double minimumValue() {
        return this.minValue;
    }

    public double maximumValue() {
        return this.maxValue;
    }

    public int getPrecision() {
        return this.maxDecimals;
    }
}

