% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_na_recode.R
\name{custom_na_recode}
\alias{custom_na_recode}
\title{Recode NA as another value using a function or a custom equation}
\usage{
custom_na_recode(
  df,
  func = "mean",
  grouping_cols = NULL,
  across_columns = NULL
)
}
\arguments{
\item{df}{A valid R `object` for which the percentage of missing values is required.}

\item{func}{Function to use for the replacement e.g "mean". Defaults to mean.}

\item{grouping_cols}{A character vector. If supplied, one can provide the columns by which to group the
data.}

\item{across_columns}{A character vector specifying across which columns recoding should be done
#use all columns
head(custom_na_recode(airquality,func="mean"))
# use only a few columns
head(custom_na_recode(airquality,func="mean",across_columns = c("Solar.R","Ozone")))
# use a function from another package
#head(custom_na_recode(airquality, func=dplyr::lead))
some_data <- data.frame(ID=c("A1","A1","A1","A2","A2", "A2"), A=c(5,NA,0,8,3,4), B=c(10,0,0,NA,5,6),C=c(1,NA,NA,25,7,8))
# grouping
head(custom_na_recode(some_data,func = "mean", grouping_cols = "ID", across_columns = c("C", "A")))
head(custom_na_recode(some_data,func = "mean", grouping_cols = "ID"))}
}
\description{
Recode NA as another value using a function or a custom equation
}
