% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_simctest.R
\name{expect_bernoulli}
\alias{expect_bernoulli}
\title{Test Bernoulli distribution using buckets}
\usage{
expect_bernoulli(object, J, ok, epsilon = 0.001, ...)
}
\arguments{
\item{object}{Function that performs one sampling step.  Returns 0 or 1.}

\item{J}{Buckets to use. A matrix with two rows, each column
describes an interval bucket. Column names give names for
the bucket(s).}

\item{ok}{Name of bucket(s) that pass the Unit test.}

\item{epsilon}{Error bound.}

\item{...}{Further parameters to be passed on to 'mctest'.}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Test if the success probability of a Bernoulli experiment lies
within a desired 'bucket'. This used the sequential procedure
described in
\insertCite{GandyHahnDing:pvaluebuckets;textual}{mcunit}.
}
\examples{
   J <- matrix(nrow=2,c(0,0.945, 0.94,0.96, 0.955,1))
   colnames(J) <- c("low","ok","high")
   gen <- function() as.numeric(runif(1)<0.95)
   expect_bernoulli(gen,J=J,ok="ok")
}
\references{
\insertAllCited{}
}
