% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbt.R
\name{tbt}
\alias{tbt}
\title{Compute MCTQ total time in bed}
\usage{
tbt(bt, gu)
}
\arguments{
\item{bt}{A \code{hms} object corresponding to the \strong{local time of going to bed}
from a standard or shift version of the MCTQ questionnaire.}

\item{gu}{A \code{hms} object corresponding to the \strong{local time of getting out of
bed} from a standard or shift version of the MCTQ questionnaire. You can
use \code{\link[=gu]{gu()}} to compute it.}
}
\value{
A \code{Duration} object corresponding to the vectorized difference
between \code{gu} and \code{bt} in a circular time frame of 24 hours.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{tbt()} computes the \strong{total time in bed} for standard and shift versions of
the Munich Chronotype Questionnaire (MCTQ).
}
\details{
\strong{Standard MCTQ} functions were created following the guidelines in
Roenneberg, Wirz-Justice, & Merrow (2003), Roenneberg, Allebrandt, Merrow, &
Vetter (2012), and from The Worldwide Experimental Platform (theWeP, n.d.).

\strong{\eqn{\mu}MCTQ} functions were created following the guidelines in Ghotbi
et al. (2020), in addition to the guidelines used for the standard MCTQ.

\strong{MCTQ\eqn{^{Shift}}{ Shift}} functions were created following the
guidelines in Juda, Vetter, & Roenneberg (2013), in addition to the
guidelines used for the standard MCTQ.

See the References section to learn more.
\subsection{Class requirements}{

The \code{mctq} package works with a set of object classes specially created to
hold time values. These classes can be found in the
\link[lubridate:lubridate-package]{lubridate} and \link[hms:hms-package]{hms}
packages. Please refer to those package documentations to learn more about
them.
}

\subsection{Rounding and fractional time}{

Some operations may produce an output with fractional time (e.g.,
\code{"19538.3828571429s (~5.43 hours)"}, \code{01:15:44.505}). If you want, you
can round it with \link[=round_time]{round_time()}.

Our recommendation is to avoid rounding, but, if you do, make sure that you
only round your values after all computations are done. That way you avoid
\href{https://en.wikipedia.org/wiki/Round-off_error}{round-off errors}.
}
}
\section{Guidelines}{


Roenneberg, Allebrandt, Merrow, & Vetter (2012), Juda, Vetter, & Roenneberg
(2013), and The Worldwide Experimental Platform (n.d.) guidelines for \code{tbt()}
(\eqn{TBT}) computation are as follows.
\subsection{Notes}{
\itemize{
\item The computation below must be applied to each section of the
questionnaire.
\item If you are visualizing this documentation in plain text (\code{ASCII}), you may
have some trouble understanding the equations. If you want a better viewer,
you can see this documentation on the package
\href{https://docs.ropensci.org/mctq/reference/}{website}.
}
}

\subsection{For standard and micro versions of the MCTQ}{

\strong{\deqn{GU_{W/F} - BT_{W/F}}{GU_W/F - BT_W/F}}

Where:
\itemize{
\item \eqn{BT_{W/F}}{BT_W/F} = local time of going to bed on work \strong{or}
work-free days ("I go to bed at ___ o'clock").
\item \eqn{GU_{W/F}}{GU_W/F} = local time of getting out of bed on work \strong{or}
work-free days.
}

\strong{*} \eqn{W} = workdays; \eqn{F} = work-free days.
}

\subsection{For the shift version of the MCTQ}{

\strong{\deqn{GU_{W/F}^{M/E/N} - BT_{W/F}^{M/E/N}}{GU_W/F_M/E/N - BT_W/F_M/E/N}}

Where:
\itemize{
\item \eqn{BT_{W/F}^{M/E/N}}{BT_W/F_M/E/N} = local time of going to bed between
two days in a particular shift \strong{or} between two free days after a
particular shift  ("I go to bed at ___ o'clock").
\item \eqn{GU_{W/F}^{M/E/N}}{GU_W/F_M/E/N} = local time of getting out of bed
between two days in a particular shift \strong{or} between two free days after a
particular shift.
}

\strong{*} \eqn{W} = workdays; \eqn{F} = work-free days, \eqn{M} =
morning shift; \eqn{E} = evening shift; \eqn{N} = night shift.
}
}

\examples{
## Scalar example

bt <- hms::parse_hm("22:10")
gu <- hms::parse_hm("06:15")
tbt(bt, gu)
#> [1] "29100s (~8.08 hours)" # Expected

bt <- hms::parse_hm("01:20")
gu <- hms::parse_hm("14:00")
tbt(bt, gu)
#> [1] "45600s (~12.67 hours)" # Expected

bt <- hms::as_hms(NA)
gu <- hms::parse_hm("07:20")
tbt(bt, gu)
#> [1] NA # Expected

## Vector example

bt <- c(hms::parse_hm("23:50"), hms::parse_hm("02:30"))
gu <- c(hms::parse_hm("09:30"), hms::parse_hm("11:25"))
tbt(bt, gu)
#> [1] "34800s (~9.67 hours)" "32100s (~8.92 hours)" # Expected
}
\references{
Ghotbi, N., Pilz, L. K., Winnebeck, E. C., Vetter, C., Zerbini, G., Lenssen,
D., Frighetto, G., Salamanca, M., Costa, R., Montagnese, S., & Roenneberg, T.
(2020). The \eqn{\mu}MCTQ: an ultra-short version of the Munich ChronoType
Questionnaire. \emph{Journal of Biological Rhythms}, \emph{35}(1), 98-110.
\doi{10.1177/0748730419886986}.

Juda, M., Vetter, C., & Roenneberg, T. (2013). The Munich ChronoType
Questionnaire for shift-workers (MCTQ\eqn{^{Shift}}{ Shift}). \emph{Journal of
Biological Rhythms}, \emph{28}(2), 130-140. \doi{10.1177/0748730412475041}.

Roenneberg T., Allebrandt K. V., Merrow M., & Vetter C. (2012). Social jetlag
and obesity. \emph{Current Biology}, \emph{22}(10), 939-43.
\doi{10.1016/j.cub.2012.03.038}.

Roenneberg, T., Wirz-Justice, A., & Merrow, M. (2003). Life between clocks:
daily temporal patterns of human chronotypes. \emph{Journal of Biological
Rhythms}, \emph{18}(1), 80-90. \doi{10.1177/0748730402239679}.

The Worldwide Experimental Platform (n.d.). MCTQ.
\url{https://www.thewep.org/documentations/mctq/}
}
\seealso{
Other MCTQ functions: 
\code{\link{fd}()},
\code{\link{gu}()},
\code{\link{le_week}()},
\code{\link{msf_sc}()},
\code{\link{msl}()},
\code{\link{napd}()},
\code{\link{sd24}()},
\code{\link{sd_overall}()},
\code{\link{sd_week}()},
\code{\link{sdu}()},
\code{\link{sjl_weighted}()},
\code{\link{sjl}()},
\code{\link{so}()}
}
\concept{MCTQ functions}
