% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_rmse}
\alias{calc_rmse}
\title{Calculate Root Mean Squared Error and its Monte Carlo Standard Error}
\usage{
calc_rmse(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.}
}
\value{
A list with two components: `rmse`, the calculated Root Mean Squared Error of the estimates,
and `rmse_mcse`, the Monte Carlo Standard Error of the RMSE. This MCSE is derived from jackknife
estimates, offering insight into the reliability of the RMSE calculation.
}
\description{
Computes the Root Mean Squared Error (RMSE) of a set of estimates relative to a true parameter value,
along with the Monte Carlo Standard Error (MCSE) for the RMSE. The RMSE is a measure of the accuracy
of the estimates, representing the square root of the average squared differences between the estimated
values and the true parameter. The MCSE for the RMSE is calculated using jackknife estimates, providing
an assessment of the uncertainty associated with the RMSE value.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50
rmse_info <- calc_rmse(estimates, true_param)
print(rmse_info)
}
