% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/referenceInterval.R
\name{refInterval}
\alias{refInterval}
\title{Calculate Reference Interval and Corresponding Confidence Interval}
\usage{
refInterval(
  x,
  out_method = c("doxin", "tukey"),
  out_rm = FALSE,
  RI_method = c("parametric", "nonparametric", "robust"),
  CI_method = c("parametric", "nonparametric", "boot"),
  refLevel = 0.95,
  bootCI = c("perc", "norm", "basic", "stud", "bca"),
  confLevel = 0.9,
  rng.seed = NULL,
  tol = 1e-06,
  R = 10000
)
}
\arguments{
\item{x}{(\code{numeric})\cr numeric measurements from target population.}

\item{out_method}{(\code{string})\cr string specifying the which outlier detection to use.}

\item{out_rm}{(\code{logical})\cr whether the outliers is removed or not.}

\item{RI_method}{(\code{string})\cr string specifying the which method for computing
reference interval to use. Default is \code{parametric}, options can be \code{nonparametric}
and \code{robust}.}

\item{CI_method}{(\code{string})\cr string specifying the which method for computing
confidence interval of reference limit(lower or upper) to use. Default is
\code{parametric}, options can be \code{nonparametric} and \code{boot}.}

\item{refLevel}{(\code{numeric})\cr reference range/interval, usual is 0.95.}

\item{bootCI}{(\code{string})\cr string specifying the which bootstrap confidence
interval from \code{boot.ci()} function in \code{boot} package. Default is
\code{perc}(bootstrap percentile), options can be \code{norm}(normal approximation),
\code{boot}(basic bootstrap), \code{stud}(studentized bootstrap) and \code{bca}(adjusted
bootstrap percentile).}

\item{confLevel}{(\code{numeric})\cr significance level for the confidence interval
of reference limit.}

\item{rng.seed}{(\code{integer})\cr number of the random number generator seed
for bootstrap sampling. If set to NULL currently in the R session used RNG
setting will be used.}

\item{tol}{(\code{numeric})\cr tolerance for when the iterative process can be
stopped in robust method.}

\item{R}{(\code{integer})\cr number of bootstrap replicates, is used in \code{boot()} function.}
}
\value{
A \code{RefInt} object contains relevant results in establishing of reference interval.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is used to establish the reference interval for target population
with parametric, non-parametric and robust methods that follows the CLSI-EP28A3
and NMPA guideline. In additional, it also provides the corresponding confidence
interval for lower/upper reference limit if needed. Given that outliers should be
identified beforehand, Tukey and Dixon methods can be applied depending on
distribution of the data.
}
\note{
There are some conditions of use to be aware of:
\itemize{
\item If parametric method is used to calculate reference interval, confidence
interval should be the same method as well.
\item If non-parametric method is used to calculate the reference interval and
the sample size is up to 120 observations, the non-parametric is suggested for
confidence interval. Otherwise if the sample size is below to 120, the bootstrap
method is the better choice. Beside the non-parametric method for confidence
interval only allows the \code{refLevel=0.95} and \code{confLevel=0.9} arguments,
if not the bootstrap methods will be used automatically.
\item If robust method is used to calculate the reference interval, the method for
confidence interval must be bootstrap.
}
}
\examples{
data("calcium")
x <- calcium$Value
refInterval(x, RI_method = "parametric", CI_method = "parametric")
refInterval(x, RI_method = "nonparametric", CI_method = "nonparametric")
refInterval(x, RI_method = "robust", CI_method = "boot", R = 1000)
}
