% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_gaussian.R
\name{f_gaussian}
\alias{f_gaussian}
\title{Specify a Gaussian sampling distribution}
\usage{
f_gaussian(
  link = "identity",
  var.prior = pr_invchisq(df = 0, scale = 1),
  var.vec = ~1,
  prec.mat = NULL,
  var.model = NULL,
  logJacobian = NULL
)
}
\arguments{
\item{link}{the name of a link function. Currently the only allowed link functions
for the Gaussian distribution is \code{"identity"}.}

\item{var.prior}{prior for the variance parameter of a Gaussian sampling distribution.
This can be specified by a call to one of the prior specification functions
\code{\link{pr_invchisq}}, \code{\link{pr_exp}}, \code{\link{pr_gig}} or \code{\link{pr_fixed}} for
inverse chi-squared, exponential, generalised inverse gaussian or degenerate prior distribution,
respectively. The default is an improper prior \code{pr_invchisq(df=0, scale=1)}. A half-t prior on the
standard deviation can be specified using \code{\link{pr_invchisq}} with a chi-squared distributed scale
parameter.}

\item{var.vec}{a formula to specify unequal variances, i.e. heteroscedasticity.
The default corresponds to equal variances.}

\item{prec.mat}{a possibly non-diagonal positive-definite symmetric matrix
interpreted as the precision matrix, i.e. inverse of the covariance matrix.
If this argument is specified \code{var.vec} is ignored.}

\item{var.model}{a formula specifying the terms of a variance model in the case of a Gaussian likelihood.
Several types of terms are supported: a regression term for the log-variance
specified with \code{\link{vreg}(...)}, and a term \code{\link{vfac}(...)} for multiplicative modelled factors
at a certain level specified by a factor variable. By using unit-level inverse-chi-squared factors the marginal
sampling distribution becomes a Student-t distribution, and by using unit-level exponential factors it becomes
a Laplace or double exponential distribution. In addition, \code{\link{reg}} and \code{\link{gen}}
can be used to specify regression or random effect terms. In that case the prior distribution
of the coefficients is not exactly normal, but instead Multivariate Log inverse Gamma (MLiG),
see also \code{\link{pr_MLiG}}.}

\item{logJacobian}{if the data are transformed the logarithm of the Jacobian can be supplied so that it
is incorporated in all log-likelihood computations. This can be useful for comparing information criteria
for different transformations. It should be supplied as a vector of the same size as the response variable,
and is currently only supported if \code{family="gaussian"}.
For example, when a log-transformation is used on response vector \code{y}, the vector \code{-log(y)}
should be supplied.}
}
\value{
A family object.
}
\description{
This function can be used in the \code{family} argument of \code{\link{create_sampler}}
or \code{\link{generate_data}} to specify a Gaussian sampling distribution.
}
