% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_coef}
\alias{plot_coef}
\title{Plot a set of model coefficients or predictions with uncertainty intervals
based on summaries of simulation results or other objects.}
\usage{
plot_coef(
  ...,
  n.se = 1,
  est.names,
  sort.by = NULL,
  decreasing = FALSE,
  index = NULL,
  maxrows = 50L,
  maxcols = 6L,
  offset = 0.1,
  cex.var = 0.8,
  mar = c(0.1, 2.1, 5.1, 0.1)
)
}
\arguments{
\item{...}{\code{dc_summary} objects (output by the \code{summary} method for
simulation objects of class \code{dc}), \code{sae} objects (output by the
functions of package \pkg{hbsae}), or lists. In case of a list the components
used are those with name \code{est} for point estimates, \code{se}
for standard error based intervals or \code{lower} and \code{upper} for
custom intervals. Instead of \code{dc_summary} objects matrix objects are
also supported as long as they contain columns named "Mean" and "SD" as do
\code{dc_summary} objects. Named parameters of other types that do not match any
other argument names are passed to lower-level plot functions.}

\item{n.se}{number of standard errors below and above the point estimates
to use for error bars. By default equal to 1. This only refers to the
objects of class \code{dc_summary} and \code{sae}.}

\item{est.names}{labels to use in the legend for the components of the \code{...} argument}

\item{sort.by}{vector by which to sort the coefficients, referring to the first object passed.}

\item{decreasing}{if \code{TRUE}, sort in decreasing order (default).}

\item{index}{vector of names or indices of the selected areas to be plotted.}

\item{maxrows}{maximum number of rows in a column.}

\item{maxcols}{maximum number of columns of estimates on a page.}

\item{offset}{space used between plots of multiple estimates for the same area.}

\item{cex.var}{the fontsize of the variable names, default=0.8.}

\item{mar}{a numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot.}
}
\description{
This function plots estimates with error bars. Multiple sets of
estimates can be compared. The error bars can either be based on
standard errors or on explicitly specified lower and upper bounds.
The function is adapted from function \code{plot.sae} in package
\pkg{hbsae}, which in turn was adapted from function
\code{coefplot.default} from package \pkg{arm}.
}
\examples{
\donttest{
# create artificial data
set.seed(21)
n <- 100
dat <- data.frame(
  x=runif(n),
  f=factor(sample(1:20, n, replace=TRUE))
)
model <- ~ reg(~ x, prior=pr_normal(precision=1), name="beta") + gen(factor=~f, name="v")
gd <- generate_data(model, data=dat)
dat$y <- gd$y
# fit a base model
model0 <- y ~ reg(~ 1, name="beta") + gen(factor=~f, name="v")
sampler <- create_sampler(model0, data=dat, block=TRUE)
sim <- MCMCsim(sampler, store.all=TRUE)
(summ0 <- summary(sim))
# fit 'true' model
model <- y ~ reg(~ x, name="beta") + gen(factor=~f, name="v")
sampler <- create_sampler(model, data=dat, block=TRUE)
sim <- MCMCsim(sampler, store.all=TRUE)
(summ <- summary(sim))
# compare random effect estimates against true parameter values
plot_coef(summ0$v, summ$v, list(est=gd$pars$v), n.se=2, offset=0.2,
  maxrows=10, est.names=c("base model", "true model", "true"))
}

}
