% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{get_draw}
\alias{get_draw}
\title{Extract a list of parameter values for a single draw}
\usage{
get_draw(obj, iter, chain)
}
\arguments{
\item{obj}{an object of class \code{mcdraws}.}

\item{iter}{iteration number.}

\item{chain}{chain number.}
}
\value{
A list with all parameter values of draw \code{iter} from chain \code{chain}.
}
\description{
Extract a list of parameter values for a single draw
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4, store.all=TRUE)
get_draw(sim, iter=20, chain=3)
}

}
