% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.mcmc}
\alias{as.mcmc}
\alias{as.mcmc.mcarray}
\alias{as.mcmc.mcmcarray}
\alias{as.mcmc.mcmc.list}
\alias{as.mcmc.mcmcr}
\title{Coerce to an mcmc object}
\usage{
\method{as.mcmc}{mcarray}(x, ...)

\method{as.mcmc}{mcmcarray}(x, ...)

\method{as.mcmc}{mcmc.list}(x, ...)

\method{as.mcmc}{mcmcr}(x, ...)
}
\arguments{
\item{x}{object to coerce.}

\item{...}{Unused.}
}
\description{
Coerces MCMC objects to an \code{\link[coda]{mcmc}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{mcarray}: Coerces mcarray object (with 1 chain) to an mcmc object

\item \code{mcmcarray}: Coerces mcmcarray object (with 1 chain) to an mcmc object

\item \code{mcmc.list}: Coerces mcmc.list object (with 1 chain) to an mcmc object

\item \code{mcmcr}: Coerces mcmcr object (with 1 chain) to an mcmc object
}}

\examples{
as.mcmc(subset(mcmcr_example, chains = 1L))
}
\seealso{
\code{coda::\link[coda]{mcmc}}
}
