% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model.mcgf}
\alias{model.mcgf}
\alias{model.mcgf_rs}
\title{Display fitted models for an \code{mcgf} or \code{mcgf_rs} object}
\usage{
\method{model}{mcgf}(
  x,
  model = c("all", "base", "lagrangian"),
  old = FALSE,
  print_model = TRUE,
  ...
)

\method{model}{mcgf_rs}(
  x,
  model = c("all", "base", "lagrangian"),
  old = FALSE,
  print_model = TRUE,
  ...
)
}
\arguments{
\item{x}{An mcgf object.}

\item{model}{Which model to display.}

\item{old}{Logical; TRUE if the old model needs to be printed.}

\item{print_model}{Logical; TRUE if time lag and forecast horizon need to be
printed.}

\item{...}{Additional arguments. Not in use.}
}
\value{
None (invisible \code{NULL}).
}
\description{
Display fitted models for an \code{mcgf} or \code{mcgf_rs} object
}
\details{
For \code{mcgf} and \code{mcgf_rs} objects, \code{\link[=model]{model()}} displays the fitted models and
their parameters. When \code{old = TRUE}, the old model is printed as well. Note
that the old model is not used for parameter estimation or for kriging.
}
\concept{functions on fitting a mcgf}
\concept{functions on fitting a mcgf_rs}
