% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CtsHypothesisTests.R
\name{showChiSq.Test}
\alias{showChiSq.Test}
\title{Show Chi-Square Test}
\usage{
showChiSq.Test(x, y = NULL, p = rep(1/length(x), length(x)),
  simulate.p.value = FALSE, nreps = 2000, verbose = 1)
}
\arguments{
\item{x}{a numeric vector or matrix. x and can also be factors}

\item{y}{a numeric vector}

\item{p}{a vector of proabilities the same length as x. Used for goodness-of-fit tests. Must be a valid distribution}

\item{simulate.p.value}{boolean, if TRUE use simulation to estimate p-value}

\item{nreps}{if simulate.p.value = TRUE number of simulations to complete}

\item{verbose}{level of visual output, 0 = silent}
}
\value{
results of \link[stats]{chisq.test} call
}
\description{
show results of a chi-square test visually using \link[stats]{chisq.test}
}
\examples{
showChiSq.Test(x = c(1,2,1), y= c(1,2,2))
}
