% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsam.R
\name{plotsam}
\alias{plotsam}
\title{Visualize Hypothetical Samples}
\usage{
plotsam(pop_mean_long, pop_profile, sam_long)
}
\arguments{
\item{pop_mean_long}{a data frame, the second output of \code{\link{setpop}}.}

\item{pop_profile}{a data frame, the third output of \code{\link{setpop}}.}

\item{sam_long}{a data frame, the second output of \code{\link{simul}}.}
}
\value{
\code{plotsam} returns a ggplot object.
}
\description{
\code{plotsam} plots the sample dataset of biomarker responses. This is used
for the hypothetical case study.
}
\examples{
set.seed(1)
setting <- setpop()
temp <- simul(setting$pop_mean)
plotsam(setting$pop_mean_long, setting$pop_profile, temp$sam_long)

}
