% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/named_triplet.R
\name{create_triplet}
\alias{create_triplet}
\title{Create a triplet from a matrix}
\usage{
create_triplet(
  m,
  retain_zero_structure = FALSE,
  i_col = "i",
  j_col = "j",
  value_col = "value"
)
}
\arguments{
\item{m}{A \code{matrix} or \code{Matrix} to be converted to triplet form.}

\item{retain_zero_structure}{A boolean that tells whether
to retain the structure of zero matrices.
Default is \code{FALSE}.}

\item{i_col, j_col, value_col}{String names of i, j, and x columns.}
}
\value{
A \code{tibble} triplet representation of \code{m}.
}
\description{
Creates a data frame triplet with columns
\code{i_col}, \code{j_col}, and \code{value_col} from matrix \code{m}.
Zero entries are not reported.
\code{i} and \code{j} integers are directly from \code{m}
and not referenced to any global set of \code{i} and \code{j} values.
}
\details{
When \code{m} is a zero matrix,
a zero-row data frame is returned by default
(\code{retain_zero_structure = FALSE}).
But when \code{retain_zero_structure} is \code{TRUE},
zero entries are reported for all rows and columns,
thereby preserving the structure of the matrix.
}
