% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinants.R
\name{rowCofactors}
\alias{rowCofactors}
\title{Row Cofactors of A[i,]}
\usage{
rowCofactors(A, i)
}
\arguments{
\item{A}{a square matrix}

\item{i}{row index}
}
\value{
a vector of the cofactors of A[i,]
}
\description{
Returns the vector of cofactors of row i of the square matrix A.  The determinant, \code{Det(A)},
can then be found as \code{M[i,] \%*\% rowCofactors(M,i)} for any row, i.
}
\examples{
M <- matrix(c(4, -12, -4,
              2,   1,  3,
             -1,  -3,  2), 3, 3, byrow=TRUE)
minor(M, 1, 1)
minor(M, 1, 2)
minor(M, 1, 3)
rowCofactors(M, 1)
Det(M)
# expansion by cofactors of row 1
M[1,] \%*\% rowCofactors(M,1)

}
\seealso{
\code{\link{Det}} for the determinant

Other determinants: 
\code{\link{Det}()},
\code{\link{adjoint}()},
\code{\link{cofactor}()},
\code{\link{minor}()},
\code{\link{rowMinors}()}
}
\author{
Michael Friendly
}
\concept{determinants}
