% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eig.R
\name{eig}
\alias{eig}
\title{Eigen Decomposition of a Square Symmetrix Matrix}
\usage{
eig(X, tol = sqrt(.Machine$double.eps), max.iter = 100,
  retain.zeroes = TRUE)
}
\arguments{
\item{X}{a square symmetrix matrix}

\item{tol}{tolerance passed to \code{\link{QR}}}

\item{max.iter}{maximum number of QR iterations}

\item{retain.zeroes}{logical; retain 0 eigenvalues?}
}
\value{
a list of two elements: \code{values}-- eigenvalues, \code{vectors}-- eigenvectors
}
\description{
\code{eig} calculates the eigenvalues and eigenvectors of a square, symmetric matrix using the iterated QR decomposition
}
\examples{
C <- matrix(c(1,2,3,2,5,6,3,6,10), 3, 3) # nonsingular, symmetric
C
EC <- eig(C) # eigenanalysis of C
EC$vectors \%*\% diag(EC$values) \%*\% t(EC$vectors) # check
}
\author{
John Fox and Georges Monette
}
\seealso{
\code{\link[base]{eigen}}

\code{\link{SVD}}
}

