% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swp.R
\name{swp}
\alias{swp}
\title{The Matrix Sweep Operator}
\usage{
swp(M, index)
}
\arguments{
\item{M}{a numeric matrix}

\item{index}{a numeric vector indicating the rows/columns to be swept.  The entries must be less than or equal
to the number or rows or columns in \code{M}.  If missing, the function sweeps on all rows/columns \code{1:min(dim(M))}.}
}
\value{
the matrix \code{M} with rows and columns in \code{indices}
}
\description{
The \code{swp} function \dQuote{sweeps} a matrix on the rows and columns given in \code{index} to produce a new matrix
with those rows and columns \dQuote{partialled out} by orthogonalization. This was defined as a fundamental statistical operation in
multivariate methods by Beaton (1964) and expanded by Dempster (1969). It is closely related to orthogonal projection,
but applied to a cross-products or covariance matrix, rather than to data.
}
\details{
If \code{M} is the partitioned matrix
\deqn{\left[ \begin{array}{cc} \mathbf {R} &  \mathbf {S} \\ \mathbf {T} &  \mathbf {U} \end{array} \right]}
where \eqn{R} is \eqn{q \times q} then \code{swp(M, 1:q)} gives
\deqn{\left[ \begin{array}{cc} \mathbf {R}^{-1} &  \mathbf {R}^{-1}\mathbf {S} \\ -\mathbf {TR}^{-1} &  \mathbf {U}-\mathbf {TR}^{-1}\mathbf {S} \\ \end{array} \right]}
}
\examples{
data(therapy)
mod3 <- lm(therapy ~ perstest + IE + sex, data=therapy)
X <- model.matrix(mod3)
XY <- cbind(X, therapy=therapy$therapy)
XY
M <- crossprod(XY)
swp(M, 1)
swp(M, 1:2)
}
\references{
Beaton, A. E. (1964), \emph{The Use of Special Matrix Operations in Statistical Calculus}, Princeton, NJ: Educational Testing Service.

     Dempster, A. P. (1969) \emph{Elements of Continuous Multivariate Analysis}. Addison-Wesley Publ. Co., Reading, Mass.
}
\seealso{
\code{\link{Proj}}, \code{\link{QR}}
}

