% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_id.R
\name{search_id}
\alias{search_id}
\title{Search for mathematician in Mathematics Genealogy Project}
\usage{
search_id(
  family = NULL,
  given = NULL,
  middle = NULL,
  university = NULL,
  year = NULL,
  thesis_keyword = NULL,
  country = NULL,
  discipline = NULL
)
}
\arguments{
\item{family}{a \code{character(1)} string with the family names.}

\item{given}{a \code{character(1)} string with the given names.}

\item{middle}{a \code{character(1)} string with the collapsed middle name(s).}

\item{university}{a \code{character(1)} string with the University at which PhD studied.}

\item{year}{a \code{character(1)} string or \code{integer(1)} with the year of completion.}

\item{thesis_keyword}{a \code{character(1)} string with keyword(s) in the PhD thesis title.}

\item{country}{a \code{character(1)} string with the country of study.}

\item{discipline}{an \code{integer(1)} with the mathematical sub-discipline code.}
}
\value{
Data frame containing all matches against the provided search terms, with columns:
\describe{
\item{\code{id}}{Mathematician ID (as required by \code{\link[=get_genealogy]{get_genealogy()}});}
\item{\code{name}}{The full name (surname first) of the mathematician;}
\item{\code{university}}{The institution at which PhD was obtained;}
\item{\code{year}}{The year PhD was completed.}
}
}
\description{
Perform an online search using information about an individual mathematician to find their ID in the \href{https://mathgenealogy.org/}{Mathematics Genealogy Project}.
}
\details{
Any one or more of the listed arguments can be provided.
This will trigger an online search against the live \href{https://mathgenealogy.org/}{Mathematics Genealogy Project} database, so please be considerate and do not spam queries.
All the information returned by a standard search on the website is gathered into a data frame and returned, enabling programmatic access to the data.

If you cannot find the individual you are looking for, it could be that they are not in the \href{https://mathgenealogy.org/}{Mathematics Genealogy Project} database.
New data can be submitted by following the instructions in the "How to submit updates" section at \url{https://mathgenealogy.org/submit.php}.
}
\examples{
# Don't test these as rely on internet resources that can be temporarily
# unavailable.
\donttest{
# Search for the package author
search_id("Aslett", "Louis")

# You may find it easier to directly use the https://mathgenealogy.org/
# website, and extract the "id" from the URL on the page for the mathematician
# of interest.
}
}
\references{
Jackson, A. (2007). “A Labor of Love: The Mathematics Genealogy Project”, \emph{Notices of the AMS}, \strong{54}(8), 1002-1003. \url{https://www.ams.org/notices/200708/tx070801002p.pdf}

Mulcahy, C. (2017). “The Mathematics Genealogy Project Comes of Age at Twenty-one”, \emph{Notices of the AMS}, \strong{64}(5), 466-470. \url{https://www.ams.org/journals/notices/201705/rnoti-p466.pdf}
}
