% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxDir.R
\name{mxDir}
\alias{mxDir}
\alias{dmxDir1}
\alias{dmxDir2}
\alias{rmxDir1}
\alias{rmxDir2}
\title{Matrix Variate Dirichlet Distributions}
\usage{
dmxDir1(X, a)

dmxDir2(X, a)

rmxDir1(p, a, S)

rmxDir2(p, a)
}
\arguments{
\item{X}{a \code{(p-by-p-by-r)} array whose density be computed.}

\item{a}{weight vector of length \code{r+1}.}

\item{p}{the dimension for sample matrix.}

\item{S}{a \code{(p-by-p)} covariance matrix required for sampling from Wishart.}
}
\description{
We have 2 types of Dirichlet distributions, namely, Type 1 and Type 2.
Like other functions, \code{dmxDir1} and \code{dmxDir2} are
to evaluate densities, while \code{rmxDir1} and \code{rmxDir2} generate
random samples accordingly to the model provided.
}
\examples{
## Sample Generations
sDir1 = rmxDir1(4,a=c(6,7,8,9),S=diag(4))
sDir2 = rmxDir2(4,a=c(9,8,7,6))


}
