% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabchk.R
\name{stabchk}
\alias{stabchk}
\title{Stability-Check}
\usage{
stabchk(
  matching,
  c.prefs,
  s.prefs,
  nColleges = ncol(c.prefs),
  nStudents = ncol(s.prefs)
)
}
\arguments{
\item{matching}{data frame or matrix of dimension (\code{min[nColleges, nStudents]}) x 2 containing in column 1 the colleges and in column 2 the students with each row forming a couple.}

\item{c.prefs}{matrix of dimension \code{nStudents} x \code{nColleges} with column j containing college j'th ranking over students in decreasing order of preferences.}

\item{s.prefs}{matrix of dimension \code{nColleges} x \code{nStudents} with column j containing student j'th ranking over colleges in decreasing order of preferences.}

\item{nColleges}{integer indicating the number of colleges}

\item{nStudents}{integer indicating the number of students}
}
\value{
\code{stabchk} returns a data frame with as many rows as blocking pairs were found. Column 1 indicates the college and column 2 indicate the student of the blocking pairs. Returns \code{NULL} if no blocking pair is found.
}
\description{
Checks a given two sided matching for blocking pairs.
}
\examples{


## 1-a. Generate preferences for colleges
c.prefs = matrix(c(1,2,3,
                   3,2,1,
                   3,2,1),
                    byrow = FALSE, ncol = 3); c.prefs

## 1-b. Generate preferences for students
s.prefs = matrix(c(1,2,3,
                   3,2,1,
                   2,1,3),
                 byrow = FALSE, ncol = 3);s.prefs

## 1-c. Generate matching
matching = matrix(c(1,2,
                    2,1,
                    3,3),
                  byrow = TRUE, ncol = 2); matching

## 1-d. Check stability
stabchk(matching = matching, c.prefs = c.prefs, s.prefs = s.prefs)

## 2-a. Generate new matching without blocking pairs as a data frame
matching = data.frame('colleges' = c(1,2,3), 'student' = c(1,3,2))
stabchk(matching = matching, c.prefs = c.prefs, s.prefs = s.prefs)

## 3-a. Example with missing values:
matching  <- matrix(c(1,1,2,2,3,3), byrow = FALSE, ncol = 2)
c.prefs <- matrix(c(1,1,3,rep(NA, 6)), byrow = TRUE, ncol = 3)
s.prefs <- matrix(c(2,2,3,rep(NA, 6)), byrow = TRUE, ncol = 3)
stabchk(matching = matching, c.prefs = c.prefs, s.prefs = s.prefs)
}
\author{
Thilo Klein, Alexander Sauer
}
\keyword{algorithms}
