/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class DistanceXYZ
extends AbstractTernIntSConstraint {
    protected int operator;
    protected final int cste;
    public static final int EQ = 0;
    public static final int LT = 1;
    public static final int GT = 2;

    public DistanceXYZ(IntDomainVar x0, IntDomainVar x1, IntDomainVar x2, int c, int op) {
        super(x0, x1, x2);
        this.cste = c;
        this.operator = op;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 3;
    }

    public boolean filterFromXYtoLBZ() throws ContradictionException {
        if (this.v1.getInf() - this.v0.getSup() > 0) {
            return this.v2.updateInf(this.v1.getInf() - this.v0.getSup() - this.cste, this, false);
        }
        if (this.v0.getInf() - this.v1.getSup() > 0) {
            return this.v2.updateInf(this.v0.getInf() - this.v1.getSup() - this.cste, this, false);
        }
        return false;
    }

    public boolean filterFromXYtoUBZ() throws ContradictionException {
        int a = Math.abs(this.v1.getSup() - this.v0.getInf());
        int b = Math.abs(this.v0.getSup() - this.v1.getInf());
        return this.v2.updateSup(Math.max(a, b) - this.cste, this, false);
    }

    public boolean filterEQFromYZToX() throws ContradictionException {
        int lb = this.v1.getInf() - this.v2.getSup() - this.cste;
        int ub = this.v1.getSup() + this.v2.getSup() + this.cste;
        int lbv0 = this.v1.getSup() - this.v2.getInf() - this.cste + 1;
        int ubv0 = this.v1.getInf() + this.v2.getInf() + this.cste - 1;
        return this.v0.updateInf(lb, this, false) || this.v0.updateSup(ub, this, false) || this.v0.removeInterval(lbv0, ubv0, this, false);
    }

    public boolean filterEQFromXZToY() throws ContradictionException {
        int lb = this.v0.getInf() - this.v2.getSup() - this.cste;
        int ub = this.v0.getSup() + this.v2.getSup() + this.cste;
        int lbv1 = this.v0.getSup() - this.v2.getInf() - this.cste + 1;
        int ubv1 = this.v0.getInf() + this.v2.getInf() + this.cste - 1;
        return this.v1.updateInf(lb, this, false) || this.v1.updateSup(ub, this, false) || this.v1.removeInterval(lbv1, ubv1, this, false);
    }

    public boolean filterLTFromYZtoX() throws ContradictionException {
        int lb = this.v1.getInf() - this.v2.getSup() - this.cste + 1;
        int ub = this.v1.getSup() + this.v2.getSup() + this.cste - 1;
        return this.v0.updateInf(lb, this, false) || this.v0.updateSup(ub, this, false);
    }

    public boolean filterLTFromXZtoY() throws ContradictionException {
        int lb = this.v0.getInf() - this.v2.getSup() - this.cste + 1;
        int ub = this.v0.getSup() + this.v2.getSup() + this.cste - 1;
        return this.v1.updateInf(lb, this, false) || this.v1.updateSup(ub, this, false);
    }

    public boolean filterGTFromYZtoX() throws ContradictionException {
        int lbv0 = this.v1.getSup() - this.v2.getInf() - this.cste;
        int ubv0 = this.v1.getInf() + this.v2.getInf() + this.cste;
        return this.v0.removeInterval(lbv0, ubv0, this, false);
    }

    public boolean filterGTFromXZtoY() throws ContradictionException {
        int lbv1 = this.v0.getSup() - this.v2.getInf() - this.cste;
        int ubv1 = this.v0.getInf() + this.v2.getInf() + this.cste;
        return this.v1.removeInterval(lbv1, ubv1, this, false);
    }

    public void filterFixPoint() throws ContradictionException {
        boolean change = true;
        while (change) {
            if (this.operator == 0) {
                change = this.filterFromXYtoLBZ();
                change |= this.filterFromXYtoUBZ();
                change |= this.filterEQFromXZToY();
                change |= this.filterEQFromYZToX();
                continue;
            }
            if (this.operator == 1) {
                change = this.filterFromXYtoLBZ();
                change |= this.filterLTFromXZtoY();
                change |= this.filterLTFromYZtoX();
                continue;
            }
            change = this.filterFromXYtoUBZ();
            change |= this.filterGTFromXZtoY();
            change |= this.filterGTFromYZtoX();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filterFixPoint();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filterFixPoint();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filterFixPoint();
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filterFixPoint();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.operator <= 1) {
            this.v2.updateInf(-this.cste, this, false);
        }
        this.filterFixPoint();
    }

    @Override
    public String toString() {
        String op;
        if (this.operator == 0) {
            op = "=";
        } else if (this.operator == 2) {
            op = ">";
        } else if (this.operator == 1) {
            op = "<";
        } else {
            throw new SolverException("unknown operator");
        }
        return "|" + this.v0 + " - " + this.v1 + "| " + op + " " + this.v2 + " + " + this.cste;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("| ").append(this.v0.pretty()).append(" - ").append(this.v1.pretty()).append(" | ");
        switch (this.operator) {
            case 0: {
                sb.append("=");
                break;
            }
            case 2: {
                sb.append(">");
                break;
            }
            case 1: {
                sb.append("<");
                break;
            }
            default: {
                sb.append("???");
            }
        }
        sb.append(this.v2 + " + " + this.cste);
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on DistanceXYC constraint");
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (this.operator == 0) {
            return Math.abs(tuple[0] - tuple[1]) == tuple[2] + this.cste;
        }
        if (this.operator == 1) {
            return Math.abs(tuple[0] - tuple[1]) < tuple[2] + this.cste;
        }
        if (this.operator == 2) {
            return Math.abs(tuple[0] - tuple[1]) > tuple[2] + this.cste;
        }
        throw new SolverException("operator not known");
    }
}

