/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;

public final class CollectionUtils {
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();

    private CollectionUtils() {
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    private static class EmptyList
    extends AbstractList<Object>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public void add(int index, Object element) {
        }

        @Override
        public Object remove(int index) {
            return null;
        }

        @Override
        public Object set(int index, Object element) {
            return null;
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static class EmptySet
    extends AbstractSet<Object>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean add(Object e) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

