/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.automata.fast_multicostregular.algo;

import choco.kernel.common.Constant;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.StoredDirectedMultiGraph;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntStack;
import java.util.Arrays;

public class FastPathFinder {
    StoredDirectedMultiGraph graph;
    int[] sp;
    int[] lp;
    int nbLayer;
    int nbR;
    public double[][] spfs;
    public double[][] spft;
    double[][] lpfs;
    double[][] lpft;
    boolean[] modified = new boolean[2];
    int[][] prevSP;
    int[][] nextSP;
    int[][] prevLP;
    int[][] nextLP;
    private double[] tmpU;

    public FastPathFinder(StoredDirectedMultiGraph graph) {
        this.graph = graph;
        this.sp = new int[graph.layers.length - 1];
        this.lp = new int[graph.layers.length - 1];
        this.nbLayer = graph.layers.length - 1;
        this.nbR = this.graph.nbR - 1;
        this.tmpU = new double[this.nbR];
        this.spfs = this.graph.GNodes.spfsI;
        this.spft = this.graph.GNodes.spftI;
        this.lpfs = this.graph.GNodes.lpfsI;
        this.lpft = this.graph.GNodes.lpftI;
        this.prevSP = this.graph.GNodes.prevSPI;
        this.nextSP = this.graph.GNodes.nextSPI;
        this.prevLP = this.graph.GNodes.prevLPI;
        this.nextLP = this.graph.GNodes.nextLPI;
    }

    private final double getCost(int e, int resource, double[] u, boolean lagrange, boolean max) {
        double cost;
        if (!lagrange) {
            cost = this.graph.GArcs.originalCost[e][resource];
        } else {
            double tmp = 0.0;
            for (int k = 1; k <= this.nbR; ++k) {
                tmp += u[k - 1] * this.graph.GArcs.originalCost[e][k];
            }
            if (max) {
                tmp = -tmp;
            }
            cost = this.graph.GArcs.originalCost[e][0] + tmp;
        }
        this.graph.GArcs.temporaryCost[e] = cost;
        return cost;
    }

    private final double[] simplifyLagrangian(double[] u) {
        for (int k = 1; k <= this.nbR; ++k) {
            this.tmpU[k - 1] = u[k - 1] - u[k - 1 + this.nbR];
        }
        return this.tmpU;
    }

    private static final boolean isAllZero(double[] u) {
        for (double d : u) {
            if (d == 0.0) continue;
            return false;
        }
        return true;
    }

    public void computeLongestPath(TIntStack removed, double lb, double[] u, boolean lagrange, boolean max, int resource) throws ContradictionException {
        double newCost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        if (lagrange) {
            if (FastPathFinder.isAllZero(u)) {
                u = null;
                lagrange = false;
                resource = 0;
            } else {
                u = this.simplifyLagrangian(u);
            }
        }
        this.graph.GNodes.lpfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.lpft[this.graph.tinIndex] = 0.0;
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                this.graph.GNodes.lpfs[dest] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e = inlist[x];
                    if (this.graph.isInStack(e) || !(this.graph.GNodes.lpfs[dest] < (newCost = this.graph.GNodes.lpfs[orig = this.graph.GArcs.origs[e]] + this.getCost(e, resource, u, lagrange, max)))) continue;
                    this.graph.GNodes.lpfs[dest] = newCost;
                    this.graph.GNodes.prevLP[dest] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                this.graph.GNodes.lpft[orig] = Double.NEGATIVE_INFINITY;
                for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int next = this.graph.GArcs.dests[e];
                    newCost = this.graph.GNodes.lpft[next] + this.graph.GArcs.temporaryCost[e];
                    if (newCost + this.graph.GNodes.lpfs[orig] - lb <= -Constant.MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e);
                        removed.push(e);
                        continue;
                    }
                    if (!(this.graph.GNodes.lpft[orig] < newCost)) continue;
                    this.graph.GNodes.lpft[orig] = newCost;
                    this.graph.GNodes.nextLP[orig] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
    }

    public final double getLongestPathValue() {
        return this.graph.GNodes.lpft[this.graph.sourceIndex];
    }

    public int[] getLongestPath() {
        int e;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e = this.graph.GNodes.nextLP[current];
            this.sp[i++] = e;
        } while (this.graph.GNodes.nextLP[current = this.graph.GArcs.dests[e]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public void computeShortestPath(TIntStack removed, double ub, double[] u, boolean lagrange, boolean max, int resource) throws ContradictionException {
        double newCost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        this.graph.GNodes.spfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.spft[this.graph.tinIndex] = 0.0;
        if (lagrange) {
            if (FastPathFinder.isAllZero(u)) {
                u = null;
                lagrange = false;
                resource = 0;
            } else {
                u = this.simplifyLagrangian(u);
            }
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                this.graph.GNodes.spfs[dest] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    int orig;
                    e = inlist[x];
                    if (this.graph.isInStack(e) || !(this.graph.GNodes.spfs[dest] > (newCost = this.graph.GNodes.spfs[orig = this.graph.GArcs.origs[e]] + this.getCost(e, resource, u, lagrange, max)))) continue;
                    this.graph.GNodes.spfs[dest] = newCost;
                    this.graph.GNodes.prevSP[dest] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                this.graph.GNodes.spft[orig] = Double.POSITIVE_INFINITY;
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int dest = this.graph.GArcs.dests[e];
                    newCost = this.graph.GNodes.spft[dest] + this.graph.GArcs.temporaryCost[e];
                    if (newCost + this.graph.GNodes.spfs[orig] - ub >= Constant.MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e);
                        removed.push(e);
                        continue;
                    }
                    if (!(this.graph.GNodes.spft[orig] > newCost)) continue;
                    this.graph.GNodes.spft[orig] = newCost;
                    this.graph.GNodes.nextSP[orig] = e;
                    update = true;
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
    }

    public final double getShortestPathValue() {
        return this.graph.GNodes.spft[this.graph.sourceIndex];
    }

    public int[] getShortestPath() {
        int e;
        int i = 0;
        int current = this.graph.sourceIndex;
        do {
            e = this.graph.GNodes.nextSP[current];
            this.sp[i++] = e;
        } while (this.graph.GNodes.nextSP[current = this.graph.GArcs.dests[e]] != Integer.MIN_VALUE);
        return this.sp;
    }

    public void computeShortestAndLongestPath(IStateIntVector removed, int lb, int ub, double[] u, boolean lagrange, boolean max, int resource) throws ContradictionException {
        double newCost2;
        double newCost;
        double cost;
        int e;
        StoredIndexedBipartiteSetWithOffset bs;
        boolean update;
        int i;
        this.graph.GNodes.spfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.spft[this.graph.tinIndex] = 0.0;
        this.graph.GNodes.lpfs[this.graph.sourceIndex] = 0.0;
        this.graph.GNodes.lpft[this.graph.tinIndex] = 0.0;
        if (lagrange) {
            if (FastPathFinder.isAllZero(u)) {
                u = null;
                lagrange = false;
                resource = 0;
            } else {
                u = this.simplifyLagrangian(u);
            }
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            DisposableIntIterator destIter = this.graph.layers[i].getIterator();
            while (destIter.hasNext()) {
                int dest = destIter.next();
                this.graph.GNodes.spfs[dest] = Double.POSITIVE_INFINITY;
                this.graph.GNodes.lpfs[dest] = Double.NEGATIVE_INFINITY;
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                DisposableIntIterator in = bs.getIterator();
                while (in.hasNext()) {
                    e = in.next();
                    if (this.graph.isInStack(e)) continue;
                    int orig = this.graph.GArcs.origs[e];
                    cost = this.getCost(e, resource, u, lagrange, max);
                    newCost = this.graph.GNodes.spfs[orig] + cost;
                    if (this.graph.GNodes.spfs[dest] > newCost) {
                        this.graph.GNodes.spfs[dest] = newCost;
                        this.graph.GNodes.prevSP[dest] = e;
                        update = true;
                    }
                    if (!(this.graph.GNodes.lpfs[dest] < (newCost2 = this.graph.GNodes.lpfs[orig] + cost))) continue;
                    this.graph.GNodes.lpfs[dest] = newCost2;
                    this.graph.GNodes.prevLP[dest] = e;
                    update = true;
                }
                in.dispose();
            }
            destIter.dispose();
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            DisposableIntIterator origIter = this.graph.layers[i].getIterator();
            while (origIter.hasNext()) {
                int orig = origIter.next();
                this.graph.GNodes.spft[orig] = Double.POSITIVE_INFINITY;
                this.graph.GNodes.lpft[orig] = Double.NEGATIVE_INFINITY;
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                DisposableIntIterator out = bs.getIterator();
                while (out.hasNext()) {
                    e = out.next();
                    if (this.graph.isInStack(e)) continue;
                    int dest = this.graph.GArcs.dests[e];
                    cost = this.graph.GArcs.temporaryCost[e];
                    newCost = this.graph.GNodes.spft[dest] + cost;
                    if (newCost + this.graph.GNodes.spfs[orig] - (double)ub >= Constant.MCR_DECIMAL_PREC) {
                        this.graph.getInStack().set(e);
                        removed.add(e);
                    } else if (this.graph.GNodes.spft[orig] > newCost) {
                        this.graph.GNodes.spft[orig] = newCost;
                        this.graph.GNodes.nextSP[orig] = e;
                        update = true;
                    }
                    newCost2 = this.graph.GNodes.lpft[dest] + cost;
                    if (newCost2 + this.graph.GNodes.lpfs[orig] - (double)lb <= -Constant.MCR_DECIMAL_PREC) {
                        this.graph.setInStack(e);
                        removed.add(e);
                        continue;
                    }
                    if (!(this.graph.GNodes.lpft[orig] < newCost2)) continue;
                    this.graph.GNodes.lpft[orig] = newCost2;
                    this.graph.GNodes.nextLP[orig] = e;
                    update = true;
                }
                out.dispose();
            }
            origIter.dispose();
            if (update) continue;
            this.graph.constraint.fail();
        }
    }

    public boolean[] computeShortestAndLongestPath(TIntStack removed, IntDomainVar[] z) throws ContradictionException {
        int d;
        double[] cost;
        int e;
        int x;
        StoredIndexedBipartiteSetWithOffset bs;
        int w;
        int size;
        int[] list;
        boolean update;
        int i;
        int nbr = z.length;
        for (int i2 = 0; i2 < nbr; ++i2) {
            this.spfs[this.graph.sourceIndex][i2] = 0.0;
            this.spft[this.graph.tinIndex][i2] = 0.0;
            this.lpfs[this.graph.sourceIndex][i2] = 0.0;
            this.lpft[this.graph.tinIndex][i2] = 0.0;
        }
        for (i = 1; i <= this.nbLayer; ++i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int dest = list[w];
                Arrays.fill(this.spfs[dest], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpfs[dest], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.inArcs[dest];
                assert (!bs.isEmpty());
                int[] inlist = bs._getStructure();
                int insize = bs.size();
                for (x = 0; x < insize; ++x) {
                    e = inlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int orig = this.graph.GArcs.origs[e];
                    cost = this.graph.GArcs.originalCost[e];
                    for (d = 0; d < nbr; ++d) {
                        if (this.spfs[dest][d] > cost[d] + this.spfs[orig][d]) {
                            this.spfs[dest][d] = cost[d] + this.spfs[orig][d];
                            this.prevSP[dest][d] = e;
                            update = true;
                        }
                        if (!(this.lpfs[dest][d] < this.lpfs[orig][d] + cost[d])) continue;
                        this.lpfs[dest][d] = this.lpfs[orig][d] + cost[d];
                        this.prevLP[dest][d] = e;
                        update = true;
                    }
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        for (i = this.nbLayer - 1; i >= 0; --i) {
            update = false;
            list = this.graph.layers[i]._getStructure();
            size = this.graph.layers[i].size();
            for (w = size - 1; w >= 0; --w) {
                int orig = list[w];
                Arrays.fill(this.spft[orig], Double.POSITIVE_INFINITY);
                Arrays.fill(this.lpft[orig], Double.NEGATIVE_INFINITY);
                bs = this.graph.GNodes.outArcs[orig];
                assert (!bs.isEmpty());
                int[] outlist = bs._getStructure();
                int outsize = bs.size();
                block7: for (x = 0; x < outsize; ++x) {
                    e = outlist[x];
                    if (this.graph.isInStack(e)) continue;
                    int dest = this.graph.GArcs.dests[e];
                    cost = this.graph.GArcs.originalCost[e];
                    for (d = 0; d < nbr; ++d) {
                        if (this.spft[dest][d] + cost[d] + this.spfs[orig][d] - (double)z[d].getSup() >= Constant.MCR_DECIMAL_PREC) {
                            this.graph.getInStack().set(e);
                            removed.push(e);
                            continue block7;
                        }
                        if (this.spft[orig][d] > this.spft[dest][d] + cost[d]) {
                            this.spft[orig][d] = this.spft[dest][d] + cost[d];
                            this.nextSP[orig][d] = e;
                            update = true;
                        }
                        if (this.lpft[dest][d] + cost[d] + this.lpfs[orig][d] - (double)z[d].getInf() <= -Constant.MCR_DECIMAL_PREC) {
                            this.graph.setInStack(e);
                            removed.push(e);
                            continue block7;
                        }
                        if (!(this.lpft[orig][d] < this.lpft[dest][d] + cost[d])) continue;
                        this.lpft[orig][d] = this.lpft[dest][d] + cost[d];
                        this.nextLP[orig][d] = e;
                        update = true;
                    }
                }
            }
            if (update) continue;
            this.graph.constraint.fail();
        }
        this.modified[0] = z[0].updateInf((int)Math.ceil(this.spft[this.graph.sourceIndex][0]), this.graph.constraint, false);
        this.modified[1] = z[0].updateSup((int)Math.floor(this.lpft[this.graph.sourceIndex][0]), this.graph.constraint, false);
        for (i = 1; i < nbr; ++i) {
            z[i].updateInf((int)Math.ceil(this.spft[this.graph.sourceIndex][i]), this.graph.constraint, false);
            z[i].updateSup((int)Math.floor(this.lpft[this.graph.sourceIndex][i]), this.graph.constraint, false);
        }
        return this.modified;
    }

    private static double[] addArray(double[] spf, double[] cost) {
        double[] out = new double[spf.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = spf[i] + cost[i];
        }
        return out;
    }
}

