/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.task;

import choco.cp.solver.search.task.SetTimesNode;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractLargeIntBranchingStrategy;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.task.RandomizedTaskSelector;
import choco.kernel.solver.search.task.TaskSelector;
import choco.kernel.solver.search.task.TaskVarSelector;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class SetTimes
extends AbstractLargeIntBranchingStrategy {
    protected final IStateInt[] flags;
    protected final IStateBitSet select;
    protected final IStateBitSet nselect;
    protected final List<TaskVar> tasksL;
    protected final TObjectIntHashMap<TaskVar> taskIndexM;
    protected final TaskVarSelector selector;
    private SetTimesNode reuseNode;
    private TaskVar reuseTask;
    private int reuseIndex;

    public SetTimes(Solver solver, List<TaskVar> tasks, Comparator<ITask> comparator) {
        this(solver, tasks, new TaskSelector(comparator));
    }

    public SetTimes(Solver solver, List<TaskVar> tasks, Comparator<ITask> comparator, long seed) {
        this(solver, tasks, new RandomizedTaskSelector(comparator, seed));
    }

    public SetTimes(Solver solver, List<TaskVar> tasks, TaskVarSelector selector) {
        this.tasksL = new ArrayList<TaskVar>(tasks);
        this.taskIndexM = new TObjectIntHashMap(this.tasksL.size());
        this.selector = selector;
        IEnvironment env = solver.getEnvironment();
        this.select = env.makeBitSet(tasks.size());
        this.nselect = env.makeBitSet(tasks.size());
        this.flags = new IStateInt[this.tasksL.size()];
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = env.makeInt();
            this.taskIndexM.put(this.tasksL.get(i), i);
        }
    }

    @Override
    public void initBranching() {
        super.initBranching();
        this.select.set(0, this.tasksL.size());
        this.nselect.clear();
    }

    @Override
    public boolean finishedBranching(IntBranchingDecision decision) {
        return ((SetTimesNode)decision.getBranchingObject()).selectables.isEmpty();
    }

    @Override
    public void setFirstBranch(IntBranchingDecision decision) {
        this.reuseNode = (SetTimesNode)decision.getBranchingObject();
        this.reuseTask = this.selector.selectTaskVar(this.reuseNode.selectables);
        this.reuseNode.setLastSelected(this.reuseTask);
    }

    @Override
    public void setNextBranch(IntBranchingDecision decision) {
        this.setFirstBranch(decision);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        int i = this.nselect.nextSetBit(0);
        while (i >= 0) {
            if (this.tasksL.get(i).getEST() != this.flags[i].get()) {
                this.select.set(i);
                this.nselect.clear(i);
            }
            i = this.nselect.nextSetBit(i + 1);
        }
        LinkedHashSet<TaskVar> l = new LinkedHashSet<TaskVar>(this.select.cardinality());
        int i2 = this.select.nextSetBit(0);
        while (i2 >= 0) {
            if (this.tasksL.get(i2).isScheduled()) {
                this.select.clear(i2);
            } else {
                l.add(this.tasksL.get(i2));
            }
            i2 = this.select.nextSetBit(i2 + 1);
        }
        if (l.isEmpty()) {
            if (!this.nselect.isEmpty()) {
                this.manager.getSolver().getPropagationEngine().raiseContradiction(this);
            }
            return null;
        }
        return new SetTimesNode(l);
    }

    @Override
    public void goDownBranch(IntBranchingDecision decision) throws ContradictionException {
        this.reuseTask = ((SetTimesNode)decision.getBranchingObject()).getLastSelected();
        this.reuseTask.start().setVal(this.reuseTask.getEST());
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
        this.reuseNode = (SetTimesNode)decision.getBranchingObject();
        this.reuseTask = this.reuseNode.getLastSelected();
        this.reuseNode.removeLastSelected();
        this.reuseIndex = this.taskIndexM.get(this.reuseTask);
        this.nselect.set(this.reuseIndex);
        this.flags[this.reuseIndex].set(this.reuseTask.getEST());
    }

    @Override
    public String getDecisionLogMessage(IntBranchingDecision decision) {
        this.reuseTask = ((SetTimesNode)decision.getBranchingObject()).getLastSelected();
        return this.reuseTask + "==" + this.reuseTask.getEST();
    }
}

