/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.disjunctive.AbstractDisjRules;
import choco.cp.solver.constraints.global.scheduling.disjunctive.BipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.disjunctive.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.trees.DisjTreeT;
import choco.cp.solver.constraints.global.scheduling.trees.DisjTreeTL;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.comparator.TaskComparators;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRMakespan;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Comparator;

public final class DisjRules
extends AbstractDisjRules {
    protected final IBipartiteQueue<IRTask> rqueue;
    protected final IBipartiteQueue<ITask> queue;
    protected final IThetaTree disjTreeT;
    protected final IThetaLambdaTree disjTreeTL;

    public DisjRules(IRTask[] rtasks, IRMakespan makespan) {
        super(rtasks, makespan, false);
        ITask[] tasks = this.getTaskArray();
        this.rqueue = new BipartiteQueue<IRTask>(rtasks);
        this.queue = new BipartiteQueue<ITask>(tasks);
        this.disjTreeT = new DisjTreeT(Arrays.asList(tasks));
        this.disjTreeTL = new DisjTreeTL(Arrays.asList(tasks));
    }

    @Override
    public final boolean isActive() {
        return true;
    }

    @Override
    public void remove(IRTask rtask) {
        throw new UnsupportedOperationException("The resource is not alternative");
    }

    private void setupListsAndTreeT(Comparator<IRTask> taskComp, Comparator<ITask> queueComp, IVilimTree.TreeMode mode) {
        DisjRules.sortQueue(this.queue, queueComp);
        this.sortRTasks(taskComp);
        this.setupMasterTree(this.disjTreeT, mode);
    }

    @Override
    public void overloadChecking() throws ContradictionException {
        this.sortRTasks(TaskComparators.makeRLatestCompletionTimeCmp());
        this.setupMasterTree(this.disjTreeT, IVilimTree.TreeMode.ECT);
        for (IRTask t : this.rtasks) {
            TaskVar i = t.getTaskVar();
            this.disjTreeT.insertInTheta(i);
            if (this.disjTreeT.getTime() <= i.getLCT()) continue;
            t.fail();
        }
        this.setMakespanLB(this.disjTreeT);
    }

    @Override
    public boolean notFirst() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeReverseREarliestCompletionTimeCmp(), TaskComparators.makeReverseEarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        ITask j = null;
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getEST() < this.queue.peek().getECT()) {
                j = this.queue.poll();
                this.disjTreeT.insertInTheta(j);
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            if (this.disjTreeT.getTime() < i.getECT()) {
                this.updateManager.storeUpdate(rti, j.getECT());
            }
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        return this.updateManager.updateEST();
    }

    @Override
    public boolean notLast() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeRLatestCompletionTimeCmp(), TaskComparators.makeLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        ITask j = null;
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getLCT() > this.queue.peek().getLST()) {
                j = this.queue.poll();
                this.disjTreeT.insertInTheta(j);
            }
            this.disjTreeT.removeFromTheta(i);
            if (this.disjTreeT.getTime() > i.getLST()) {
                this.updateManager.storeUpdate(rti, j.getLST());
            }
            this.disjTreeT.insertInTheta(i);
        }
        this.setMakespanLB(this.disjTreeT);
        return this.updateManager.updateLCT();
    }

    @Override
    public boolean detectablePrecedenceEST() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeREarliestCompletionTimeCmp(), TaskComparators.makeLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getECT() > this.queue.peek().getLST()) {
                this.disjTreeT.insertInTheta(this.queue.poll());
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            this.updateManager.storeUpdate(rti, this.disjTreeT.getTime());
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        this.setMakespanLB(this.disjTreeT);
        return this.updateManager.updateEST();
    }

    @Override
    public boolean detectablePrecedenceLCT() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeReverseRLatestCompletionTimeCmp(), TaskComparators.makeReverseEarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getLCT() <= this.queue.peek().getECT()) {
                this.disjTreeT.insertInTheta(this.queue.poll());
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            this.updateManager.storeUpdate(rti, this.disjTreeT.getTime());
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        return this.updateManager.updateLCT();
    }

    @Override
    public boolean edgeFindingEST() throws ContradictionException {
        DisjRules.sortQueue(this.rqueue, TaskComparators.makeReverseRLatestCompletionTimeCmp());
        this.disjTreeTL.setMode(IVilimTree.TreeMode.ECT);
        this.setMakespanLB(this.disjTreeTL);
        IRTask rtj = this.rqueue.peek();
        TaskVar j = rtj.getTaskVar();
        if (this.disjTreeTL.getTime() > j.getLCT()) {
            rtj.fail();
        }
        do {
            this.rqueue.poll();
            if (!rtj.isRegular()) continue;
            this.disjTreeTL.removeFromThetaAndInsertInLambda(rtj);
            if (this.rqueue.isEmpty()) break;
            rtj = this.rqueue.peek();
            j = rtj.getTaskVar();
            if (this.disjTreeTL.getTime() > j.getLCT()) {
                rtj.fail();
            }
            while (this.disjTreeTL.getGrayTime() > j.getLCT()) {
                IRTask rti = (IRTask)this.disjTreeTL.getResponsibleTask();
                TaskVar i = rti.getTaskVar();
                if (this.disjTreeTL.getTime() > i.getEST()) {
                    this.updateManager.storeUpdate(rti, this.disjTreeTL.getTime());
                }
                this.disjTreeTL.removeFromLambda(i);
            }
        } while (!this.rqueue.isEmpty());
        return this.updateManager.updateEST();
    }

    @Override
    public boolean edgeFindingLCT() throws ContradictionException {
        DisjRules.sortQueue(this.rqueue, TaskComparators.makeREarliestStartingTimeCmp());
        this.disjTreeTL.setMode(IVilimTree.TreeMode.LST);
        IRTask rtj = this.rqueue.peek();
        TaskVar j = rtj.getTaskVar();
        if (this.disjTreeTL.getTime() < j.getEST()) {
            rtj.fail();
        }
        do {
            this.rqueue.poll();
            if (!rtj.isRegular()) continue;
            this.disjTreeTL.removeFromThetaAndInsertInLambda(rtj);
            if (this.rqueue.isEmpty()) break;
            rtj = this.rqueue.peek();
            j = rtj.getTaskVar();
            if (this.disjTreeTL.getTime() < j.getEST()) {
                rtj.fail();
            }
            while (this.disjTreeTL.getGrayTime() < j.getEST()) {
                IRTask rti = (IRTask)this.disjTreeTL.getResponsibleTask();
                TaskVar i = rti.getTaskVar();
                this.updateManager.storeUpdate(rti, this.disjTreeTL.getTime());
                this.disjTreeTL.removeFromLambda(i);
            }
        } while (!this.rqueue.isEmpty());
        return this.updateManager.updateLCT();
    }
}

